<?php
/**
* Modulo MercadoPago Tools Pro
*
* @author    Kijam
* @copyright 2020 Kijam
* @license   Commercial use allowed (Non-assignable & non-transferable),
*            can modify source-code but cannot distribute modifications
*            (derivative works).
*/

class AdminSuscriptionOrdersController extends ModuleAdminController
{
    private $module_name = 'mptoolspro';
    private $module_instance;
    private $cache = array();
    public function __construct()
    {
        parent::__construct();
        $this->context = Context::getContext();
        $this->module_instance = Module::getInstanceByName($this->module_name);
        $this->bootstrap = true; // use Bootstrap CSS
        $this->table = UKijam::DB_PREFIX.'_preapprovals'; // SQL table name, will be prefixed with _DB_PREFIX_
        $this->identifier = 'id'; // SQL column to be used as primary key
        $this->className = 'SuscriptionOrders'; // PHP class name
        $this->allow_export = false; // allow export in CSV, XLS..
        $this->_defaultOrderBy = 'a.end_payment'; // the table alias is always `a`
        $this->_defaultOrderWay = 'DESC';
        $this->_where = 'AND a.id_shop = '.(int)Context::getContext()->shop->id;
        $this->fields_list = array(
            'id' => array(
                'title' => 'ID',
                'class' => 'fixed-width-xs',
                'remove_onclick' => true,
            ),
            'status' => array(
                'title' => 'Estado',
                'align' => 'center',
                'search' => false,
                'remove_onclick' => true,
                'callback' => 'printStatus',
                'orderby' => true,
            ),
            'id_cart_base' => array(
                'title' => 'Cliente',
                'align' => 'center',
                'callback' => 'printCustomer',
                'orderby' => false,
                'search' => false,
                'remove_onclick' => true,
                'orderby' => true,
            ),
            'products' => array(
                'title' => 'Productos',
                'align' => 'left',
                'callback' => 'printProducts',
                'orderby' => false,
                'search' => false,
                'remove_onclick' => true,
                'orderby' => true,
            ),
            'next_payment' => array(
                'title' => 'Fechas',
                'align' => 'left',
                'callback' => 'printDate',
                'orderby' => false,
                'search' => false,
                'remove_onclick' => true,
                'orderby' => true,
            )
        );
        $this->bulk_actions = array(
            'delete' => array(
                'text' => $this->l('Cancel selected'),
                'confirm' => $this->l('Cancel selected items?'),
                'icon' => 'icon-trash'
            )
        );
        $this->addRowAction('delete');
    }
    private function getObj($id)
    {
        if (!isset($this->cache[$id])) {
            $this->cache[$id] = new SuscriptionOrders($id);
        }
        return $this->cache[$id];
    }
    public function printStatus($value, $pack)
    {
        $suscription = $this->getObj($pack['id']);
        $color = '#555';
        switch ($suscription->status) {
            case 'cancel':
                $color = '#f00';
                break;
            case 'pause':
                $color = '#00f';
                break;
            case 'end':
                $color = '#000';
                break;
        }
        return '<span style="padding: 2px;border-radius: 6px;color:#fff;background-color:'.$color.'">
                    '.$suscription->status_txt.'
                </span>';
    }
    public function printDate($value, $pack)
    {
        $suscription = $this->getObj($pack['id']);
        $link = $this->context->link->getAdminLink(
            'AdminOrders',
            true
        ).'&vieworder=1&id_order='.$suscription->last_order->id.'';
        $html = '<b>Próximo Cobro:</b> '.$suscription->next_payment_txt.'<br />';
        $html .= '<b>Próximo Envío:</b> '.$suscription->next_send_txt.'<br />';
        $html .= '<b>Finaliza:</b> '.date('Y-m-d', strtotime($suscription->end_payment)).'<br />';
        $html .= '<b>Última Order:</b> <a href="'.$link.'" target="_blank">'.$suscription->last_order->id.'</a><br />';
        return $html;
    }
    public function printProducts($value, $pack)
    {
        $suscription = $this->getObj($pack['id']);
        $orders = $suscription->getOrders();
        $html = '';
        $lang = $this->context->language->id;
        foreach ($orders['orders'] as $o) {
            foreach ($o['products'] as $p) {
                if ($p['qty'] > 0) {
                    $product = new Product($p['id_product']);
                    $html .= '- <b>'.$p['qty'] .' x '.$product->name[$lang].'</b> cada '.
                                $o['frequency'].' '.$o['setting']['frequency_type'].
                             '<br />';
                }
            }
        }
        return $html;
    }
    public function printCustomer($value, $pack)
    {
        $suscription = $this->getObj($pack['id']);
        $link = $this->context->link->getAdminLink(
            'AdminAddresses',
            true
        ).'&updateaddress=1&id_address='.$suscription->cart_base->id_address_delivery.'';
        return '<a class="btn btn-success" href="'.$link.'" target="_blank">'.$suscription->customer->firstname.'</a>';
    }
    public function initProcess()
    {
        parent::initProcess();
        $id = (int)Tools::getValue('id');
        if (Tools::isSubmit('toggleFSFirstPack') && $id > 0) {
            $m = new SuscriptionPacks($this->id_object);
            $m->is_public = !$m->is_public;
            $m->save();
        } elseif (Tools::isSubmit('toggleFSRecurringPack') && $id > 0) {
            $m = new SuscriptionPacks($this->id_object);
            $m->is_public = !$m->is_public;
            $m->save();
        } elseif (Tools::isSubmit('togglePublicPack') && $id > 0) {
            $m = new SuscriptionPacks($this->id_object);
            $m->is_public = !$m->is_public;
            $m->save();
        }
    }
}
