<?php
/**
* Modulo MercadoPago Tools Pro
*
* @author    Kijam
* @copyright 2020 Kijam
* @license   Commercial use allowed (Non-assignable & non-transferable),
*            can modify source-code but cannot distribute modifications
*            (derivative works).
*/

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * Array of settings
 */
return array(
    'MLA'          => array(
        'NAME' => 'Argentina',
        'CURRENCY' => 'ARS',
        'ISO' => 'AR',
        'BTN_COUNTRY' => 'Ar',
        'UNIT_PRICE_TYPE' => 'FLOAT',
        'DNI_NAME' => 'DNI',
        'TOKEN_JS' => 'https://www.mercadopago.com.ar/integrations/v1/web-tokenize-checkout.js',
        'REGISTER_URL' => 'https://www.mercadopago.com/mla/registration',
        'SECRET_URL' => 'https://www.mercadolibre.com/jms/mla/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mla/account/credentials%3Ftype%3Dbasic',
        'PUBLICKEY_URL' => 'https://www.mercadolibre.com/jms/mla/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mla/account/credentials',
        'ACCEPT_DIGITAL_CURRENCY' => false,
        'MPENVIOS_REGISTER_URL' => 'http://envios.mercadolibre.com.ar/optin/doOptin',
        'INSTALLMENT_FEE' => array(
            3, 6, 12, 18
        ),
        'CARRIER_LIST' => array(
            array(
                'id' => 73330,
                'name' => 'Envío Prioritario',
            ),
            array(
                'id' => 73328,
                'name' => 'Envío Estándar',
            ),
            array(
                'id' => 504245,
                'name' => 'Envío Normal',
            ),
        ),
        'MP_SHIPPING_MIN_W' => 10,
        'MP_SHIPPING_MAX_W' => 250,
        'MP_SHIPPING_MIN_H' => 10,
        'MP_SHIPPING_MAX_H' => 250,
        'MP_SHIPPING_MIN_D' => 10,
        'MP_SHIPPING_MAX_D' => 250,
        'MP_SHIPPING_MIN_WE' => 100,
        'MP_SHIPPING_MAX_WE' => 35000
    ),
    'MLM'          => array(
        'NAME' => 'Mexico',
        'CURRENCY' => 'MXN',
        'ISO' => 'MX',
        'BTN_COUNTRY' => 'Mx',
        'UNIT_PRICE_TYPE' => 'FLOAT',
        'DNI_NAME' => 'DNI',
        'TOKEN_JS' => 'https://www.mercadopago.com.mx/integrations/v1/web-tokenize-checkout.js',
        'REGISTER_URL' => 'https://www.mercadopago.com/mlm/registration',
        'SECRET_URL' => 'https://www.mercadolibre.com/jms/mlm/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mlm/account/credentials%3Ftype%3Dbasic',
        'PUBLICKEY_URL' => 'https://www.mercadolibre.com/jms/mlm/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mlm/account/credentials',
        'ACCEPT_DIGITAL_CURRENCY' => true,
        'MPENVIOS_REGISTER_URL' => 'http://shipping.mercadopago.com.mx/optin/doOptin',
        'INSTALLMENT_FEE' => array(
            3, 6, 9, 12, 18
        ),
        'CARRIER_LIST' => array(
            array(
                'id' => 501245,
                'name' => 'DHL Estándar',
            ),
            array(
                'id' => 501345,
                'name' => 'DHL Express',
            ),
            array(
                'id' => 509446,
                'name' => 'Estándar a domicilio',
            ),
            array(
                'id' => 509450,
                'name' => 'Express a domicilio',
            ),
        ),
        'MP_SHIPPING_MIN_W' => 10,
        'MP_SHIPPING_MAX_W' => 80,
        'MP_SHIPPING_MIN_H' => 10,
        'MP_SHIPPING_MAX_H' => 80,
        'MP_SHIPPING_MIN_D' => 10,
        'MP_SHIPPING_MAX_D' => 120,
        'MP_SHIPPING_MIN_WE' => 100,
        'MP_SHIPPING_MAX_WE' => 30000
    ),
    'MLB'          => array(
        'NAME' => 'Brasil',
        'CURRENCY' => 'BRL',
        'ISO' => 'BR',
        'BTN_COUNTRY' => 'Br',
        'UNIT_PRICE_TYPE' => 'FLOAT',
        'DNI_NAME' => 'CPF',
        'TOKEN_JS' => 'https://www.mercadopago.com.br/integrations/v1/web-tokenize-checkout.js',
        'REGISTER_URL' => 'https://www.mercadopago.com/mlb/registration',
        'SECRET_URL' => 'https://www.mercadolibre.com/jms/mlb/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mlb/account/credentials%3Ftype%3Dbasic',
        'IPN_URL' => 'https://www.mercadopago.com/mlb/ferramentas/notificacoes',
        'PUBLICKEY_URL' => 'https://www.mercadolibre.com/jms/mlb/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mlb/account/credentials',
        'ACCEPT_DIGITAL_CURRENCY' => false,
        'MPENVIOS_REGISTER_URL' => 'http://envios.mercadolivre.com.br/optin/doOptin',
        'CARRIER_LIST' => array(
            array(
                'id' => 100009,
                'name' => 'Normal',
            ),
            array(
                'id' => 182,
                'name' => 'Expresso',
            ),
        ),
        'MP_SHIPPING_MIN_W' => 16,
        'MP_SHIPPING_MAX_W' => 105,
        'MP_SHIPPING_MIN_H' => 11,
        'MP_SHIPPING_MAX_H' => 105,
        'MP_SHIPPING_MIN_D' => 2,
        'MP_SHIPPING_MAX_D' => 105,
        'MP_SHIPPING_MIN_WE' => 100,
        'MP_SHIPPING_MAX_WE' => 15000
    ),
    'MLC'          => array(
        'NAME' => 'Chile',
        'CURRENCY' => 'CLP',
        'ISO' => 'CL',
        'BTN_COUNTRY' => 'Cl',
        'UNIT_PRICE_TYPE' => 'INTEGER',
        'DNI_NAME' => 'RUT',
        'TOKEN_JS' => 'https://www.mercadopago.cl/integrations/v1/web-tokenize-checkout.js',
        'REGISTER_URL' => 'https://www.mercadopago.com/mlc/registration',
        'SECRET_URL' => 'https://www.mercadolibre.com/jms/mlc/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mlc/account/credentials%3Ftype%3Dbasic',
        'PUBLICKEY_URL' => 'https://www.mercadolibre.com/jms/mlc/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mlc/account/credentials',
        'ACCEPT_DIGITAL_CURRENCY' => false
    ),
    'MLV'          => array(
        'NAME' => 'Venezuela',
        'CURRENCY' => 'VEF',
        'ISO' => 'VE',
        'BTN_COUNTRY' => 'Ve',
        'UNIT_PRICE_TYPE' => 'INTEGER',
        'DNI_NAME' => 'DNI',
        'TOKEN_JS' => 'https://www.mercadopago.com.ve/integrations/v1/web-tokenize-checkout.js',
        'REGISTER_URL' => 'https://www.mercadopago.com/mlv/registration',
        'SECRET_URL' => 'https://www.mercadolibre.com/jms/mlv/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mlv/account/credentials%3Ftype%3Dbasic',
        'PUBLICKEY_URL' => 'https://www.mercadolibre.com/jms/mlv/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mlv/account/credentials',
        'ACCEPT_DIGITAL_CURRENCY' => false
    ),
    'MCO'          => array(
        'NAME' => 'Colombia',
        'CURRENCY' => 'COP',
        'ISO' => 'CO',
        'BTN_COUNTRY' => 'Co',
        'UNIT_PRICE_TYPE' => 'INTEGER',
        'DNI_NAME' => 'DNI',
        'TOKEN_JS' => 'https://www.mercadopago.com.co/integrations/v1/web-tokenize-checkout.js',
        'REGISTER_URL' => 'https://www.mercadopago.com/mco/registration',
        'SECRET_URL' => 'https://www.mercadolibre.com/jms/mco/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mco/account/credentials%3Ftype%3Dbasic',
        'PUBLICKEY_URL' => 'https://www.mercadolibre.com/jms/mco/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mco/account/credentials',
        'ACCEPT_DIGITAL_CURRENCY' => false
    ),
    'MPE'          => array(
        'NAME' => 'Peru',
        'CURRENCY' => 'PEN',
        'ISO' => 'PE',
        'BTN_COUNTRY' => 'Pe',
        'UNIT_PRICE_TYPE' => 'FLOAT',
        'DNI_NAME' => 'DNI',
        'TOKEN_JS' => 'https://www.mercadopago.com.pe/integrations/v1/web-tokenize-checkout.js',
        'REGISTER_URL' => 'https://registration.mercadopago.com.pe/registration-mp?mode=mp',
        'SECRET_URL' => 'https://www.mercadolibre.com/jms/mpe/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mpe/account/credentials%3Ftype%3Dbasic',
        'PUBLICKEY_URL' => 'https://www.mercadolibre.com/jms/mpe/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mpe/account/credentials',
        'ACCEPT_DIGITAL_CURRENCY' => false
    ),
    'MLU'          => array(
        'NAME' => 'Uruguay',
        'CURRENCY' => 'UYU',
        'ISO' => 'UY',
        'BTN_COUNTRY' => 'Ur',
        'UNIT_PRICE_TYPE' => 'FLOAT',
        'DNI_NAME' => 'DNI',
        'TOKEN_JS' => 'https://www.mercadopago.com.uy/integrations/v1/web-tokenize-checkout.js',
        'REGISTER_URL' => 'https://registration.mercadopago.com.uy/registration-mp?mode=mp',
        'SECRET_URL' => 'https://www.mercadolibre.com/jms/mlu/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mlu/account/credentials%3Ftype%3Dbasic',
        'IPN_URL' => 'https://www.mercadopago.com/mlu/herramientas/notificaciones',
        'PUBLICKEY_URL' => 'https://www.mercadolibre.com/jms/mlu/lgz/login?platform_id=mp&go='.
                            'https://www.mercadopago.com/mlu/account/credentials',
        'ACCEPT_DIGITAL_CURRENCY' => false
    ),
);
