<?php

class ToolsProMutex {
    private $file  = null;
    private $filename  = null;
    private $own   = false;
    function __construct( $key )
    {
        $this->filename = dirname(__FILE__).'/../'."$key.lockfile";
        $this->file = fopen($this->filename, 'w+');
        if ($this->file === false || !is_resource($this->file)) {
            $msg = "El archivo $key.lockfile no se pudo crear, verifique que el directorio ".
                   dirname($p).' tiene permisos de escritura. '.(function_exists('error_get_last')?error_get_last():'');
            die($msg);
        }
    }
    function __destruct()
    {
        if ( $this->own )
            $this->releaseLock();
        if (is_resource($this->file)) {
            fclose($this->file);
        }
    }
    public function lock($wait = false)
    {
        if ($this->file === false || !is_resource($this->file)) {
            $this->file = fopen($this->filename, 'w+');
        }
        if ($this->file === false || !is_resource($this->file)) {
            return false;
        }
        if ( !flock($this->file, $wait?LOCK_EX:(LOCK_EX | LOCK_NB)) )
        {
            return false;
        }
        ftruncate($this->file, 0);
        fwrite( $this->file, "Locked\n");
        fflush( $this->file );
        $this->own = true;
        return true;
    }
    public function unlock() {
        return $this->releaseLock();
    }
    public function releaseLock()
    {
        $result = false;
        if( $this->own )
        {
            ftruncate($this->file, 0);
            fwrite( $this->file, "Unlocked\n");
            fflush( $this->file );
            $result = flock($this->file, LOCK_UN);
        }
        fclose($this->file);
        $this->file = false;
        $this->own = false;
        return $result;
    }
}