<?php
namespace MercadoPago\Http;

use Exception;

/**
 * CurlRequest Class Doc Comment
 *
 * @package MercadoPago\Http
 */
class CurlRequest
    implements HttpRequest
{
    /**
     * @var null|resource
     */
    private $handle = null;
    private $uri = null;

    /**
     * @codeCoverageIgnore
     * CurlRequest constructor.
     *
     * @param null $uri
     */
    public function __construct($uri = null)
    {
        if (!extension_loaded("curl")) {
            \UKijam::log('cURL extension not found');
            throw new Exception("cURL extension not found. You need to enable cURL in your php.ini or another configuration you have.");
        }
        $this->uri = $uri;
    }
    public function connect()
    {
        if (!$this->handle) {
            $this->handle = curl_init($this->uri);
            \UKijam::log('REST-Request[NEW CURL]: '.\UKijam::pL($this->handle, true).\UKijam::pL($this->uri, true));
        }
        return $this->handle;
    }
    /**
     * @codeCoverageIgnore
     * @param $name
     * @param $value
     */
    public function setOption($name, $value)
    {
        $this->connect();
        //\UKijam::log('REST-Request[setOption]: '.\UKijam::pL($this->handle, true).' - '.\UKijam::pL($name, true).': '.\UKijam::pL($value, true));
        curl_setopt($this->handle, $name, $value);
    }

    /**
     * @codeCoverageIgnore
     * @return mixed
     */
    public function execute()
    {
        $this->connect();
        //\UKijam::log('REST-Request[execute]: '.\UKijam::pL($this->handle, true));
        return curl_exec($this->handle);
    }

    /**
     * @codeCoverageIgnore
     * @param $name
     *
     * @return mixed
     */
    public function getInfo($name)
    {
        $this->connect();
        return curl_getinfo($this->handle, $name);
    }

    /**
     *@codeCoverageIgnore
     */
    public function close()
    {
        if ($this->handle) {
            \UKijam::log('REST-Request[close]: '.\UKijam::pL($this->handle, true));
            curl_close($this->handle);
            $this->handle = null;
        }
    }

    /**
     * @codeCoverageIgnore
     * @return string
     */
    public function error()
    {
        return !$this->handle?'Handle is null '.var_export($this->handle, true):'Curl error: '.curl_error($this->handle);
    }
}