<?php
/**
* Modulo MercadoPago Tools Pro
*
* @author    Kijam
* @copyright 2020 Kijam
* @license   Commercial use allowed (Non-assignable & non-transferable),
*            can modify source-code but cannot distribute modifications
*            (derivative works).
*/

if (!interface_exists('PrestaShop\PrestaShop\Core\Module\WidgetInterface')) {
    include_once(dirname(__FILE__).'/mptoolspro_16.php');
}
class MPToolsPro extends PaymentModule implements PrestaShop\PrestaShop\Core\Module\WidgetInterface
{
    public $id_carrier;
    public $gateway = null;

    public function __construct()
    {
        static $running = false;
        $this->name = 'mptoolspro';
        $this->tab = 'payments_gateways';
        $this->version = '5.3.8';
        $this->author = 'Kijam';
        $this->module_key = '529acf1abc2bd9b8772b9b42c46b47bb';
        $this->need_instance = true;
        $this->ps_versions_compliancy = array('min' => '1.5', 'max' => _PS_VERSION_);
        if (version_compare(_PS_VERSION_, '1.7.1.0') >= 0) {
            $this->controllers = array('redirect', 'page');
            $this->currencies = true;
            $this->currencies_mode = 'checkbox';
        }
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('MercadoPago Tools Pro');
        $this->description = $this->l('MercadoPago platform tools for all country.');

        if (!defined('_PS_VERSION_')) {
            exit;
        }
        if (version_compare(_PS_VERSION_, '1.7.1.0') >= 0) {
            if (!count(Currency::checkPaymentCurrencies($this->id))) {
                $w = $this->trans('No currency has been set for this module.', array(), 'Modules.Checkpayment.Admin');
                $this->warning = $w;
            }
        }
        if (!class_exists('BaseGatewayKijam')) {
            require_once(dirname(__FILE__).'/lib/vendor/autoload.php');
            require_once(dirname(__FILE__).'/lib/mpmutex.php');
            MercadoPago\SDK::setRestClientParams('ca_file', dirname(__FILE__).'/lib/cacert-2019-05-15.pem');
            require_once(dirname(__FILE__).'/gateway.php');
            /*
            include_once(dirname(__FILE__).'/ukijam.php');
            require_once(dirname(__FILE__).'/mpclasstk.php');
            include_once(dirname(__FILE__).'/mercadopago_gateway.php');
            include_once(dirname(__FILE__).'/mercadoenvios_gateway.php');
            include_once(dirname(__FILE__).'/suscription_gateway.php');
            include_once(dirname(__FILE__).'/admin_gateway.php');
            include_once(dirname(__FILE__).'/base_gateway.php');
            include_once(dirname(__FILE__).'/class.SuscriptionOrders.php');
            include_once(dirname(__FILE__).'/class.SuscriptionPacks.php');
            include_once(dirname(__FILE__).'/class.SuscriptionPackProducts.php');
            */
        }
        if (!$running) {
            $running = true;
            $this->gateway = BaseGatewayKijam::getInstance($this->name, $this);
            if ($this->active) {
                if ($this->gateway) {
                    UKijam::init();
                    $this->gateway->initConfig();
                    $this->warning .= $this->gateway->warning;
                    $settings = $this->gateway->getSettings();
                    if ($settings && isset($settings['ISO']) && !empty($settings['ISO'])) {
                        $this->limited_countries = array(Tools::strtolower($settings['ISO']));
                    } else {
                        $this->limited_countries = array('ve', 'ar', 'mx', 'br', 'co', 'cl', 'uy', 'pe');
                    }
                    if (Tools::isSubmit('submitBulkMercadoEnvios')) {
                        $this->gateway->hookDisplayAdminOrderMercadoEnvios(false, $_POST);
                    }
                }
            } else {
                $this->gateway = BaseGatewayKijam::getInstance($this->name, $this);
                $this->limited_countries = array('ve', 'ar', 'mx', 'br', 'co', 'cl', 'uy', 'pe');
            }
            $running = false;
        }
        /* For 1.4.3 and less compatibility */
        $update_config = array('PS_OS_CHEQUE',
                            'PS_OS_PAYMENT',
                            'PS_OS_PREPARATION',
                            'PS_OS_SHIPPING',
                            'PS_OS_CANCELED',
                            'PS_OS_REFUND',
                            'PS_OS_ERROR',
                            'PS_OS_OUTOFSTOCK',
                            'PS_OS_BANKWIRE',
                            'PS_OS_PAYPAL',
                            'PS_OS_WS_PAYMENT');

        foreach ($update_config as $u) {
            if (!Configuration::get($u) && defined('_'.$u.'_')) {
                Configuration::updateValue($u, constant('_'.$u.'_'));
            }
        }
    }
    public function getDeliveryOptionList($cart, $default_country, $flush, $result)
    {
        if ($this->gateway)
            return $this->gateway->overrideGetDeliveryOptionList($cart, $result, $default_country, $flush);
        return $result;
    }
    public function install()
    {
        $incompatible_found = false;
        if (!function_exists('curl_version')) {
            $this->_errors[] = $this->l('Curl not installed');
            $incompatible_found = true;
        }
        if (!$this->gateway) {
            $this->_errors[] = $this->l('Internal error on MercadoPago Library');
            $incompatible_found = true;
        }
        if ($incompatible_found) {
            return false;
        }

        $db_created = $this->gateway->installDb();

        if (!$db_created) {
            $this->_errors[] = $this->l('Failed to create the table in the Database');
        } else {
            $is_17 = version_compare(_PS_VERSION_, '1.7.0.0') >= 0;
            $is_171 = version_compare(_PS_VERSION_, '1.7.1.0') >= 0;
            $result = parent::install();
            if (!$result) {
                $this->_errors[] = $this->l('Failed on parent::install: ').UKijam::pL($this->_errors, true);
            } else {
                $result = $this->registerHook('orderConfirmation')
                    && $this->registerHook('updateOrderStatus')
                    && $this->registerHook('displayMyAccountBlock')
                    && $this->registerHook('displayCustomerAccount')
                    && $this->registerHook('paymentTop')
                    && $this->registerHook('cancelProduct')
                    && $this->registerHook('actionOrderSlipAdd')
                    && $this->registerHook('updateCarrier')
                    && $this->registerHook('displayAdminOrder')
                    && $this->registerHook('displayHeader')
                    && $this->registerHook('displayBackOfficeHeader')
                    && $this->registerHook('displayPDFInvoice')
                    && $this->registerHook('dashboardZoneOne')
                    && $this->registerHook('dashboardData')
                    && $this->registerHook('displayAdminProductsExtra')
                    && $this->registerHook('actionProductSave')
                    && $this->registerHook('actionCartSave')
                    && $this->registerHook('displayAdminAfterHeader')
                    && $this->registerHook('actionFrontControllerSetMedia')
                    && (!$is_17?$this->registerHook('payment'):true)
                    && ($is_17?$this->registerHook('paymentOptions'):true)
                    && ($is_17?$this->registerHook('actionCartUpdateQuantityBefore'):true)
                    && ($is_171?$this->registerHook('paymentReturn'):true)
                    && ($is_17?$this->registerHook('displayCartExtraProductActions'):true)
                    && ($is_17?$this->registerHook('actionDeleteProductInCartAfter'):true)
                    && ($is_171?$this->registerHook('actionObjectProductInCartDeleteAfter'):true);
                if ($result) {
                    if ($is_171) {
                        $result = $this->registerHook('displayProductAdditionalInfo');
                    } else {
                        $result = $this->registerHook('displayProductButtons');
                    }
                }
                if (!$result) {
                    $this->_errors[] = $this->l('Failed on registerHook');
                }
            }
        }
        if ($result) {
            @chmod(dirname(__FILE__).'/', 0755);
        } else {
            $this->gateway->uninstall();
        }
        return (bool)$result;
    }
    public function uninstall()
    {
        if ($this->gateway) {
            $this->gateway->uninstall();
        }
        return parent::uninstall();
    }
    public function hookDisplayProductButtons($params)
    {
        if (!$this->gateway) {
            return;
        }
        $this->gateway->initConfig();
        $result = $this->gateway->hookDisplayProductButtons($params);
        
        if (is_array($result) && count($result) > 0) {
            $this->context->smarty->assign($result);
            return $this->display(__FILE__, 'views/templates/hook/productactions.tpl');
        }
    }
    public function hookDisplayProductAdditionalInfo($params)
    {
        return $this->hookDisplayProductButtons($params);
    }
    public function hookDisplayPDFInvoice($params)
    {
        if ($this->gateway) {
            $this->gateway->initConfig();
            $order_invoice = $params['object'];
            if (!Validate::isLoadedObject($order_invoice) || !isset($order_invoice->id_order)) {
                return;
            }
            return $this->gateway?$this->gateway->hookDisplayPDFInvoice($params):'';
        }
        return '';
    }
    public function hookDisplayMyAccountBlock($params)
    {
        if ($this->gateway) {
            $this->gateway->initConfig();
        }
        return $this->gateway ? $this->gateway->myAccountBlock($params, $this->smarty, __FILE__) : null;
    }
    public function hookDisplayCustomerAccount($params)
    {
        if ($this->gateway) {
            $this->gateway->initConfig();
        }
        return $this->gateway ? $this->gateway->myAccountBlock($params, $this->smarty, __FILE__) : null;
    }
    public function hookPDFInvoice($params)
    {
        return $this->hookDisplayPDFInvoice($params);
    }
    public function hookDashboardZoneOne($params)
    {
        return $this->display(__FILE__, 'views/templates/hook/dashboard_zone_one.tpl');
    }
    public function hookDashboardData($params)
    {
        $balance = false;
        if ($this->gateway) {
            $balance = $this->gateway->getBalance();
        }
        if ($balance) {
            return array(
                'data_value' => array(
                    $this->name.'_total_amount' => $balance['total_amount'].' '.$balance['currency_id'],
                    $this->name.'_available_balance' => $balance['available_balance'].' '.$balance['currency_id'],
                    $this->name.'_unavailable_balance' => $balance['unavailable_balance'].' '.$balance['currency_id'],
                ),
                'data_trends' => array(
                ),
                'data_list_small' => array(
                ),
                'data_chart' => array(
                ),
            );
        } else {
            return array(
                'data_value' => array(
                    $this->name.'_total_amount' => '-',
                    $this->name.'_available_balance' => '-',
                    $this->name.'_unavailable_balance' => '-',
                ),
                'data_trends' => array(
                ),
                'data_list_small' => array(
                ),
                'data_chart' => array(
                ),
            );
        }
    }
    public function hookDisplayHeader($params)
    {
        return $this->hookHeader($params);
    }
    public function hookHeader($params)
    {
        if (!$this->gateway) {
            return '';
        }
        $this->gateway->initConfig();
        if (method_exists($this->context->controller, 'registerStylesheet')) {
            $this->context->controller->registerStylesheet(
                'module-'.$this->name.'-lightslider',
                'modules/'.$this->name.'/views/css/lightslider.min.css',
                [
                  'media' => 'all',
                  'priority' => 200,
                ]
            );
            $this->context->controller->registerStylesheet(
                'module-'.$this->name.'-page_list',
                'modules/'.$this->name.'/views/css/page_list.css',
                [
                  'media' => 'all',
                  'priority' => 201,
                ]
            );
            $this->context->controller->registerJavascript(
                'module-'.$this->name.'-lightsliderjs',
                'modules/'.$this->name.'/views/js/lightslider.min.js',
                [
                  'priority' => 200,
                ]
            );
            $this->context->controller->registerJavascript(
                'module-'.$this->name.'-list_page',
                'modules/'.$this->name.'/views/js/list_page.js',
                [
                  'priority' => 201,
                ]
            );
            $this->context->controller->registerJavascript(
                'module-'.$this->name.'-check_price',
                'modules/'.$this->name.'/views/js/check_price.js',
                [
                  'priority' => 202,
                  'attribute' => 'async',
                ]
            );
        } else {
            Context::getContext()->controller->addJS(($this->_path).'views/js/check_price.js');
        }
        $result = $this->gateway->hookHeader($this->smarty, __FILE__);
        Context::getContext()->controller->addJS(($this->_path).'views/js/check_price.js');
        return $result;
    }
    public function hookDisplayBackOfficeHeader($params)
    {
        return $this->hookBackOfficeHeader($params);
    }
    public function hookBackOfficeHeader($params)
    {
        if ($this->gateway) {
            $this->gateway->initConfig();
            $result = $this->gateway->cronjob();
            return $this->gateway->hookBackOfficeHeader($params, $this->smarty, __FILE__);
        }
        return '';
    }
    public function hookDisplayAdminAfterHeader($params)
    {
        if ($this->gateway) {
            $this->gateway->initConfig();
            if (Tools::isSubmit('controller') && Tools::getValue('controller') == 'AdminOrders'
                && !Tools::isSubmit('id_order')) {
                if ($result = $this->gateway->hookDisplayAdminOrderMercadoEnvios($params)) {
                    $this->context->smarty->assign($result);
                    return $this->display(__FILE__, 'views/templates/hook/displayAdminOrderMercadoEnvios.tpl');
                }
            }
        }
        return '';
    }
    public function hookDisplayAdminOrder($params)
    {
        if (!isset($params['id_order']) || !$this->gateway) {
            return '';
        }
        $this->gateway->initConfig();
        $this->gateway->init();
        if ($result = $this->gateway->hookDisplayAdminOrder($params, __FILE__)) {
            $this->context->smarty->assign($result);
            return $this->display(__FILE__, 'views/templates/hook/displayAdminOrder.tpl');
        }
        return '';
    }
    public function hookAdminOrder($params)
    {
        return $this->hookDisplayAdminOrder($params);
    }
    public function hookOrderConfirmation($params)
    {
        if (!$this->active || !$this->gateway) {
            return;
        }
        $order = null;
        if (isset($params['objOrder'])) {
            $order = $params['objOrder'];
        } elseif (isset($params['order'])) {
            $order = $params['order'];
        } else {
            return;
        }
        if ($order->module != $this->name) {
            return;
        }
        $this->gateway->initConfig();
        $assigns = $this->gateway->hookOrderConfirmation($order);
        $this->context->smarty->assign($assigns);
        return $this->display(__FILE__, 'views/templates/hook/hookorderconfirmation.tpl');
    }
    public function getContent()
    {
        if (!$this->gateway) {
            return;
        }
        $this->gateway->initConfig();
        $this->gateway->init();
        return $this->gateway->adminPage($this->smarty, __FILE__);
    }
    public function getPathTemplate()
    {
        return $this->_path;
    }
    public function hookPayment($params)
    {
        if ($this->gateway) {
            $this->gateway->initConfig();
            $this->gateway->init();
            return $this->gateway->paymentButton16($this->context);
        }
        return '';
    }
    public function hookPaymentOptions($params)
    {
        if (!$this->active) {
            return;
        }
        if ($this->gateway) {
            $this->gateway->initConfig();
            $this->gateway->init();
            return $this->gateway->paymentButton17($this->context);
        }
        return array();
    }
    public function hookPaymentReturn($params)
    {
        if (!$this->active) {
            return '';
        }
        return '';
    }
    public function hookDisplayPaymentTop()
    {
        if (Tools::isSubmit('mptools_error')) {
            $this->context->smarty->assign(array(
                'msg' => Tools::getValue('mptools_error'),
            ));
            return $this->display(__FILE__, 'views/templates/hook/message_error.tpl');
        }
    }
    public function hookUpdateOrderStatus($params)
    {
        UKijam::log('hookUpdateOrderStatus:0');
        if ($this->gateway) {
            UKijam::log('hookUpdateOrderStatus:0.1');
            $this->gateway->initConfig();
            $this->gateway->init();
            UKijam::log('hookUpdateOrderStatus:0.2');
            return $this->gateway->hookUpdateOrderStatus($params);
        }
        UKijam::log('hookUpdateOrderStatus:0.3');
        return '';
    }
    public function hookDisplayAdminProductsExtra($params)
    {
        if (!$this->active) {
            return;
        }
        if ($this->gateway) {
            $this->gateway->initConfig();
            if ($this->gateway && ($result = $this->gateway->hookDisplayAdminProductsExtra($params))) {
                $this->context->smarty->assign($result);
                return $this->display(__FILE__, 'views/templates/admin/psetting.tpl');
            }
        }
        return '';
    }
    public function hookActionProductSave($params)
    {
        if (!$this->active) {
            return;
        }
        if ($this->gateway) {
            $this->gateway->initConfig();
            return $this->gateway->hookActionProductSave($params);
        }
    }
    public function renderWidget($hookName, array $configuration)
    {
        if ($this->gateway) {
            $this->gateway->initConfig();
            if (!isset($this->gateway->config['plan_enable']) || !$this->gateway->config['plan_enable']) {
                return '';
            }
        } else {
            return '';
        }
        $this->gateway->init();
        if ($hookName == 'list') {
            $r = $this->getWidgetVariables($hookName, $configuration);
            $this->smarty->assign($r);
            return $this->fetch('module:mptoolspro/views/templates/front/home.tpl');
        } elseif ($hookName == 'next_shipping') {
            $sql = 'SELECT p.* FROM `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_preapprovals` p
                            INNER JOIN `'.bqSQL(_DB_PREFIX_).'cart` c ON c.id_cart = p.id_cart_base 
                            WHERE p.`status` <> \'cancel\' AND p.`status` <> \'end\' AND p.`status` <> \'pause\'
                                  AND c.`id_customer` = '.(int)pSQL($this->context->cookie->id_customer).'';
            $preapprovals = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS($sql);
            //echo $sql;
            $el = false;
            if ($this->context->cookie->id_customer > 0 && is_array($preapprovals) && count($preapprovals)) {
                foreach ($preapprovals as $p) {
                    $next_send = 0;
                    $p['products'] = Tools::jsonDecode($p['products'], true);
                    if ($p['status'] == 'cancel') {
                        $p['status_txt'] = 'Cancelado';
                    } elseif ($p['status'] == 'pause') {
                        $p['status_txt'] = 'Pausado';
                    } elseif ($p['status'] == 'end') {
                        $p['status_txt'] = 'Finalizado';
                    } else {
                        $p['status_txt'] = 'Activo';
                    }
                    foreach ($p['products']['orders'] as $o) {
                        foreach ($o['products'] as $op) {
                            $oproduct = new Product($op['id_product']);
                            if (!$oproduct->is_virtual && $op['qty']) {
                                if ($next_send == 0 || $next_send > $o['next_payment']) {
                                    $next_send = $o['next_payment'];
                                }
                            }
                        }
                    }
                    $p['next_send'] = $next_send;
                    $p['next_send_txt'] = date('Y-m-d', $next_send);
                    if (!$el || $el['next_send'] > $next_send) {
                        $el = $p;
                    }
                }
            }
            $this->smarty->assign(array('el' => $el));
            return $this->fetch('module:mptoolspro/views/templates/front/next_shipping.tpl');
        }
    }
    public function getWidgetVariables($hookName, array $configuration)
    {
        $id_shop = Shop::getContextShopID();
        $r = Db::getInstance()->ExecuteS('
                    SELECT m.* FROM `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_suscription_packs` m
                    WHERE
                        m.`id_shop` = '.(int)$id_shop.' AND
                        m.`is_public` = 1');
        foreach ($r as &$e) {
            $e['url'] = Context::getContext()->link->getModuleLink(
                'mptoolspro',
                'plan',
                array('id_suscription_pack' => $e['id'])
            );
        }
        return array('list' => $r, 'hookName' => $hookName, 'configuration' => $configuration);
    }
    //INIT_NO_MERCADOENVIOS
    public function getOrderShippingCost($params, $shipping_cost)
    {
        if ($this->gateway) {
            return $this->gateway->getOrderShippingCost($params, $shipping_cost, $this->id_carrier);
        }
        return $shipping_cost;
    }
    public function hookActionCarrierUpdate($params)
    {
        return $this->hookUpdateCarrier($params);
    }
    public function hookUpdateCarrier($params)
    {
        if ($this->gateway) {
            $this->gateway->initConfig();
            return $this->gateway->hookUpdateCarrier($params);
        }
    }
    public function hookDisplayCartExtraProductActions($params)
    {
        if ($this->gateway) {
            $this->gateway->initConfig();
            return $this->gateway->hookDisplayCartExtraProductActions($params);
        }
    }
    public function hookActionObjectProductInCartDeleteAfter($params)
    {
        if ($this->gateway) {
            $this->gateway->initConfig();
            return $this->gateway->hookActionObjectProductInCartDeleteAfter($params);
        }
    }
    public function hookActionDeleteProductInCartAfter($params)
    {
        if ($this->gateway) {
            $this->gateway->initConfig();
            return $this->gateway->hookActionDeleteProductInCartAfter($params);
        }
    }
    public function hookActionCartUpdateQuantityBefore($params)
    {
        if ($this->gateway) {
            $this->gateway->initConfig();
            return $this->gateway->hookActionCartUpdateQuantityBefore($params);
        }
    }
    public function hookActionFrontControllerSetMedia($params)
    {
    }

    public function actionOrderSlipAdd(
        $order,
        $product_list,
        $shipping_cost = false,
        $amount = 0,
        $amount_choosen = false,
        $add_tax = true
    ) {
        UKijam::log("run actionOrderSlipAdd");
        $products = array();
        if (count($product_list) > 0) {
            $all_products = $order->getProducts();
            $discount = $order->total_discounts_tax_excl;
            $discount_tax = $order->total_discounts_tax_incl - $discount;
            $total_p = $order->total_products;
            $total_ptax = $order->total_products_wt - $order->total_products;
            foreach ($product_list as $p) {
                $v = $all_products[(int)$p['id_order_detail']];
                if (isset($v['total_refunded_tax_incl'])) {
                    $cancel_quantity = $p['quantity'];
                    $sales_tax = $p['total_refunded_tax_incl'] - $p['total_refunded_tax_excl'];
                    $p_price = $p['total_refunded_tax_excl'];
                    $pi = (int)$v['product_attribute_id'] > 0?'PA'.$v['product_attribute_id']:'P'.$v['product_id'];
                    $products[] = array(
                        'product_identifier' => $pi,
                        'description' => trim(preg_replace('~[^a-zA-Z0-9 ]+~', '', $v['product_name'])),
                        'product_attribute_id' => $v['product_attribute_id'],
                        'product_id' => $v['product_id'],
                        'quantity' => $cancel_quantity,
                        'unit_price' => Tools::ps_round($p_price / $cancel_quantity, 4),
                        'sales_tax' => Tools::ps_round($sales_tax, 2)
                    );
                } else {
                    $cancel_quantity = $p['product_quantity'];
                    $sales_tax = $p['amount_tax_incl'] - $p['amount_tax_excl'];
                    $p_price = $p['amount_tax_excl'];
                    $pi = (int)$v['product_attribute_id'] > 0?'PA'.$v['product_attribute_id']:'P'.$v['product_id'];
                    $products[] = array(
                        'product_identifier' => $pi,
                        'description' => trim(preg_replace('~[^a-zA-Z0-9 ]+~', '', $v['product_name'])),
                        'product_attribute_id' => $v['product_attribute_id'],
                        'product_id' => $v['product_id'],
                        'quantity' => $cancel_quantity,
                        'unit_price' => Tools::ps_round($p_price / $cancel_quantity, 4),
                        'sales_tax' => Tools::ps_round($sales_tax, 2)
                    );
                }
            }
        }
        if ($shipping_cost > 0
            && $order->total_shipping_tax_incl > $order->total_shipping_tax_excl
            && $order->total_shipping_tax_excl > 0) {
            $ratio_shipping = $order->total_shipping_tax_incl / $order->total_shipping_tax_excl;

            $shipping = $shipping_cost / $ratio_shipping;
            $shipping_tax = $shipping_cost - $shipping;
        } else {
            $shipping = $shipping_cost > 0?$shipping_cost:0;
            $shipping_tax = 0;
        }
 
        UKijam::log(
            '## Order: '.$order->id."\n".
            '## Product_list: '.UKijam::pL($product_list, true)."\n".
            '## Shipping_cost: '.UKijam::pL($shipping_cost, true)."\n".
            '## Amount: '.UKijam::pL($amount, true)."\n".
            '## Amount_choosen: '.UKijam::pL($amount_choosen, true)."\n".
            '## Add_tax: '.UKijam::pL($add_tax, true)."\n".
            '## ListRefund: '.UKijam::pL($products, true)."\n".
            '## ShippingRefund: '.$shipping.', '.$shipping_tax
        );

        if (count($products) > 0 || $shipping_cost > 0) {
            $result = $this->gateway->commitRefund($order->id, $products, $shipping, $shipping_tax);
            UKijam::log("commitRefund: ".UKijam::pL($result, true));
        }
    }
    
    public function hookActionOrderSlipAdd($params)
    {
        $order = $params['order'];
        $slips = OrderSlip::getOrdersSlip($order->id_customer, $order->id);
        UKijam::log("hookActionOrderSlipAdd: ".UKijam::pL($slips, true));
        $s = $slips[0];
        $productsOld = OrderSlip::getOrdersSlipProducts($s['id_order_slip'], $order);
        UKijam::log("hookActionOrderSlipAdd productsOld: ".UKijam::pL($productsOld, true));
        $products =  $params['productList'];
        $fp = count($products) > 0?reset($products):false;
        UKijam::log("hookActionOrderSlipAdd products: ".UKijam::pL($fp, true).'-'.UKijam::pL($products, true));
        if ($fp && is_array($fp) && isset($fp['total_refunded_tax_incl'])) {
            $this->actionOrderSlipAdd($order, $products, $s['shipping_cost']?$s['shipping_cost_amount']:0);
        } else {
            $this->actionOrderSlipAdd($order, $productsOld, $s['shipping_cost']?$s['shipping_cost_amount']:0);
        }
    }
    public function hookCancelProduct($params)
    {
        UKijam::log("hookCancelProduct: ".UKijam::pL($params, true));
        /*
        if (Tools::isSubmit('generateDiscount') || Tools::isSubmit('generateCreditSlip')) {
            return;
        }

        if (Tools::getValue('cancelProduct')) {
            $order = new Order((int)Tools::getValue('id_order'));
            if (!Validate::isLoadedObject($order)) {
                return;
            }

            if (!empty($order->invoice_number)) {
                UKijam::log("hookCancelProduct: ".UKijam::pL($slips, true));
                $order_detail = new OrderDetail((int)$params['id_order_detail']);
                if (!$order_detail || !Validate::isLoadedObject($order_detail)) {
                    return;
                }

                $all_products = $order->getProducts();
                $cancel_quantity = Tools::getValue('cancelQuantity');
                $products = array();

                $v = $all_products[(int)$order_detail->id];
                $discount = $order->total_discounts_tax_excl;
                $discount_tax = $order->total_discounts_tax_incl - $discount;
                $total_p = $order->total_products;
                $total_ptax = $order->total_products_wt - $order->total_products;

                $sales_tax = ($v['unit_price_tax_incl'] - $v['unit_price_tax_excl']) * $v['product_quantity'];
                $p_price = $v['unit_price_tax_excl'] * $v['product_quantity'];

                $percent_product = $p_price / $total_p;
                $percent_product_tax = $sales_tax / $total_ptax;
                $p_price -= $discount * $percent_product;
                $sales_tax -= $discount_tax * $percent_product_tax;
                $pi = (int)$v['product_attribute_id'] > 0?'PA'.$v['product_attribute_id']:'P'.$v['product_id'];
                $products[] = array(
                    'product_identifier' => $pi,
                    'description' => trim(preg_replace('~[^a-zA-Z0-9 ]+~', '', $v['product_name'])),
                    'product_attribute_id' => $v['product_attribute_id'],
                    'product_id' => $v['product_id'],
                    'quantity' => $cancel_quantity,
                    'unit_price' => Tools::ps_round($p_price / $v['product_quantity'], 4),
                    'sales_tax' => Tools::ps_round(($sales_tax / $v['product_quantity']) * $cancel_quantity, 2)
                );
                $rcommit = $this->gateway->commitRefund($order->id, $products);
                UKijam::log('commitRefund Product: '.UKijam::pL($rcommit, true));
            }
        }
        */
    }

    //END_NO_MERCADOENVIOS
    public function lang($str, $specific = false)
    {
        return $this->l($str, $specific);
    }
    public function waitingPayment()
    {
        return $this->l('Waiting payment on MercadoPago');
    }
}
