<?php
/**
* Upgrade de MercadoPago
*
* @author    Kijam
* @copyright 2020 Kijam
* @license   Comercial
*/

if (!defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_5_3_4($mp)
{
    if (!$mp || $mp->name != 'mptoolspro') {
        $mp = Module::getInstanceByName('mptoolspro');
    }
    if (!$mp->gateway) {
        return true;
    }
    UKijam::log('upgrade_module_5_3_4 init...');
    UKijam::log('upgrade_module_5_3_4 cancelProduct...');
    $mp->registerHook('cancelProduct');
    $mp->registerHook('actionOrderSlipAdd');
    UKijam::log('upgrade_module_5_3_4 ALTER TABLE...');
    Db::getInstance()->Execute('
        ALTER TABLE `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_refunds`
            ADD COLUMN `total_refunded` DOUBLE DEFAULT NULL
    ');
    UKijam::log('upgrade_module_5_3_4 CREATE TABLE...');
    Db::getInstance()->Execute('
    CREATE TABLE IF NOT EXISTS `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_refunds_product` (
        `id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
        `id_order` INT(11) NOT NULL,
        `product_id` INT(11) NOT NULL,
        `product_attribute_id` INT(11) DEFAULT NULL,
        `qty` FLOAT NOT NULL,
        UNIQUE(id_order, product_id, product_attribute_id),
        INDEX(id_order),
        INDEX(product_id),
        INDEX(product_attribute_id)
    )');
    if ($mp->active) {
        UKijam::log('upgrade_module_5_3_4 uninstallOverrides...');
        $mp->uninstallOverrides();
        UKijam::log('upgrade_module_5_3_4 installOverrides...');
        $mp->installOverrides();
    }
    UKijam::log('upgrade_module_5_3_4 end!');
    return true;
}