<?php
/**
* Upgrade de MercadoPago
*
* @author    Kijam
* @copyright 2020 Kijam
* @license   Comercial
*/

if (!defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_5_1_0($mp)
{
    if (!$mp || $mp->name != 'mptoolspro') {
        $mp = Module::getInstanceByName('mptoolspro');
    }
    if (!$mp->gateway) {
        return true;
    }
    UKijam::log('upgrade_module_5_1_0 init...');
    if (isset($mp->gateway->list_shippings['mp_ps']) && is_array($mp->gateway->list_shippings['mp_ps'])) {
        foreach ($mp->gateway->list_shippings['mp_ps'] as $id_carrier) {
            $carrier = new Carrier($id_carrier);
            if ($carrier->deleted) {
                continue;
            }
            UKijam::log('Carrier: '.UKijam::pL($carrier, true));
            $carrier->deleted = true;
            $carrier->active = false;
            $carrier->save();
        }
    }
    UKijam::log('upgrade_module_5_1_0 end!');
    return true;
}
