{*
* Pagina administrativa
*
* @author    Kijam
* @copyright 2020 Kijam
* @license   Commercial use allowed (Non-assignable & non-transferable),
*            can modify source-code but cannot distribute modifications
*            (derivative works).
*}
<form action="" method="post" id="formKMP" enctype="multipart/form-data" class="form-horizontal">
    <ps-panel icon="icon-cogs" header="{$display_name|escape:'htmlall':'UTF-8'}">

        <ps-input-text name="publickey"
            label="{l s='Public Key' mod='mptoolspro'}"
            help="{l s='Enter your Public Key' mod='mptoolspro'}" size="10"
            value="{if isset($publickey)}{$publickey|escape:'htmlall':'UTF-8'}{/if}"
            hint="{l s='Enter your Public Key' mod='mptoolspro'}"></ps-input-text>

        <ps-input-text name="secretkey"
            label="{l s='Secret Key (Access Token)' mod='mptoolspro'}"
            help="{l s='Enter your Secret Key' mod='mptoolspro'}" size="10"
            value="{if isset($secretkey)}{$secretkey|escape:'htmlall':'UTF-8'}{/if}"
            hint="{l s='Enter your Secret Key' mod='mptoolspro'}"></ps-input-text>

        <ps-input-text name="lic" 
            label="{l s='Licencia' mod='mptoolspro'}"
            help="{l s='Ingresa tu licencia para usar el modulo' mod='mptoolspro'}" size="10" 
            value="{if isset($lic)}{$lic|escape:'htmlall':'UTF-8'}{/if}"
            required-input="true" 
            hint="{l s='Ingresa tu licencia para usar el modulo' mod='mptoolspro'}"></ps-input-text>
            
        <ps-label-information>
            <ps-alert-warn>
                <b>{l s='Search your public key and secret key here' mod='mptoolspro'}:</b>
            {foreach from=$data_settings item=country}
                <a href="{$country.PUBLICKEY_URL|escape:'htmlall':'UTF-8'}" target="_blank">{$country.NAME|escape:'htmlall':'UTF-8'}</a>
            {/foreach}
            <!--
            {if isset($expire) and $expire}<br /><br /><b>Su licencia expira el:</b> {$expire|escape:'htmlall':'UTF-8'}. Luego
            podras seguir usando el modulo pero no obtendras nuevas actualizaciones.{/if}
            -->
        </ps-alert-warn>
        </ps-label-information>

        {if isset($secretkey) and isset($publickey) and $api_me}
            <ps-switch name="preorder"
                label="{l s='Create order before payment for QR and Basic Checkout (Highly recommended for high traffic and little inventory)' mod='mptoolspro'}"
                yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
                {if isset($preorder) && $preorder}active="true"{/if}></ps-switch>

            <ps-switch name="installment_calculator"
                label="{l s='Show Installment Calculator on Payment Button' mod='mptoolspro'}"
                yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
                {if isset($installment_calculator) && $installment_calculator}active="true"{/if}></ps-switch>

           <ps-switch name="installment_pcalculator"
                label="{l s='Show Installment Calculator on product sheet' mod='mptoolspro'}"
                yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
                {if isset($installment_pcalculator) && $installment_pcalculator}active="true"{/if}></ps-switch>

            <ps-switch name="commision_fee_checkout"
                label="{l s='Show price with fee on checkout page' mod='mptoolspro'}"
                yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
                {if isset($commision_fee_checkout) && $commision_fee_checkout}active="true"{/if}></ps-switch>

            <ps-select name="os_authorization" label="{l s='Accepted payment status' mod='mptoolspro'}">
                {foreach from=$order_states item=val}
                    <option value="{$val.id_order_state|escape:'htmlall':'UTF-8'}" {if isset($os_authorization) and $val.id_order_state == $os_authorization}data-selected="true"{/if}>{$val.name|escape:'htmlall':'UTF-8'}</option>
                {/foreach}
            </ps-select>
            <ps-select name="os_refused" label="{l s='Error or Invalid payment status' mod='mptoolspro'}">
                {foreach from=$order_states item=val}
                    <option value="{$val.id_order_state|escape:'htmlall':'UTF-8'}" {if isset($os_refused) and  $val.id_order_state == $os_refused}data-selected="true"{/if}>{$val.name|escape:'htmlall':'UTF-8'}</option>
                {/foreach}
            </ps-select>
            <ps-select name="status_refound[]" multiple="true" label="{l s='Refound money if the order has one of these status' mod='mptoolspro'}">
                {foreach from=$order_states item=val}
                    <option value="{$val.id_order_state|escape:'htmlall':'UTF-8'}" {if isset($status_refound) and in_array($val.id_order_state, $status_refound)}data-selected="true"{/if}>{$val.name|escape:'htmlall':'UTF-8'}</option>
                {/foreach}
            </ps-select>
            {if isset($test_user.seller) and isset($test_user.seller.email) and isset($test_user.buyer) and isset($test_user.seller.password)}
            <ps-label-information>
                <p>{l s='Active the test mode using the "Client ID" and "Secret ID" of "Seller Test User" and buy on the store using "Buyer Test User".' mod='mptoolspro'}</p>
                <ul class="bulleted">
                    <li><p>{l s='MercadoPago Seller Test E-Mail' mod='mptoolspro'}: <b>{$test_user.seller.email|escape:'htmlall':'UTF-8'}</b></p></li>
                    <li><p>{l s='MercadoPago Seller Test Password' mod='mptoolspro'}: <b>{$test_user.seller.password|escape:'htmlall':'UTF-8'}</b></p></li>
                    <li><p>{l s='MercadoPago Buyer Test E-Mail' mod='mptoolspro'}: <b>{$test_user.buyer.email|escape:'htmlall':'UTF-8'}</b></p></li>
                    <li><p>{l s='MercadoPago Buyer Test Password' mod='mptoolspro'}: <b>{$test_user.buyer.password|escape:'htmlall':'UTF-8'}</b></p></li>
                </ul>
                <p>{l s='According to the payment method you use, you can generate the simulated payment report with a particular state.' mod='mptoolspro'}</p>
                <p>{l s='Choose between different means of payment and generates a specific answer:' mod='mptoolspro'} <a href="https://www.mercadopago.com.ar/developers/es/guides/payments/web-checkout/testing/" target="_blank">https://www.mercadopago.com.ar/developers/es/guides/payments/web-checkout/testing/</a></p>
            </ps-label-information>
            {/if}
        {/if}
        <ps-switch name="debug"
            label="{l s='Actve Log, see log on:' mod='mptoolspro'} {$log_path|escape:'htmlall':'UTF-8'}"
            yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
            {if isset($debug) && $debug}active="true"{/if}></ps-switch>
        <ps-panel-footer>
            <ps-panel-footer-submit title="{l s='Save changes' mod='mptoolspro'}" icon="process-icon-save" direction="right" name="submitPanel"></ps-panel-footer-submit>
        </ps-panel-footer>
    </ps-panel>
    {if isset($secretkey) and isset($publickey) and $api_me}
    <ps-panel icon="icon-cogs" header="{l s='MercadoPago QR checkout' mod='mptoolspro'}">
        <ps-switch name="mp_qr_enable"
            label="{l s='Actve payment with QR Image' mod='mptoolspro'}"
            yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
            {if isset($mp_qr_enable) && $mp_qr_enable}active="true"{/if}></ps-switch>

        <div id="form_qr_div">
            <ps-input-text name="mp_qr_name"
                label="{l s='Display Name in Payment Checkout' mod='mptoolspro'}"
                help="{l s='Display Name in Payment Checkout' mod='mptoolspro'}" size="10"
                value="{if isset($mp_qr_name)}{$mp_qr_name|escape:'htmlall':'UTF-8'}{/if}"
                hint="{l s='Enter the display name in Payment Checkout' mod='mptoolspro'}"></ps-input-text>

            <ps-input-text name="fee_qr"
                label="{l s='Percent of Commission charge to customer for using MercadoPago' mod='mptoolspro'}"
                help="{l s='Percent of Commission charge to customer for using MercadoPago' mod='mptoolspro'}" size="10"
                value="{if isset($fee_qr)}{$fee_qr|escape:'htmlall':'UTF-8'}{/if}"
                fixed-width="lg"
                hint="{l s='Percent of Commission charge to customer for using MercadoPago' mod='mptoolspro'}"></ps-input-text>

            <ps-input-text name="fee_amount_qr"
                label="{l s='Amount of commission charge to customer for using MercadoPago, in' mod='mptoolspro'} {$settings.CURRENCY|escape:'htmlall':'UTF-8'}"
                help="{l s='Amount of commission charge to customer for using MercadoPago, in' mod='mptoolspro'} {$settings.CURRENCY|escape:'htmlall':'UTF-8'}" size="10"
                value="{if isset($fee_amount_qr)}{$fee_amount_qr|escape:'htmlall':'UTF-8'}{/if}"
                fixed-width="lg"
                hint="{l s='Amount of commission charge to customer for using MercadoPago, in' mod='mptoolspro'} {$settings.CURRENCY|escape:'htmlall':'UTF-8'}"></ps-input-text>

            <ps-switch name="commision_fee_qr"
                label="{l s='Show price with fee on product sheet' mod='mptoolspro'}"
                yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
                {if isset($commision_fee_qr) && $commision_fee_qr}active="true"{/if}></ps-switch>

            <ps-input-file name="file_qr_checkout"
                label="{l s='Attach the QR Image for payment on MercadoPago' mod='mptoolspro'}"
                help="{l s='Attach only JPG or PNG images with a maximum size of 500px x 500px.' mod='mptoolspro'}" size="10"
                hint="{l s='Attach only JPG or PNG images with a maximum size of 500px x 500px' mod='mptoolspro'}"></ps-input-file>
            {if isset($logo_qr_checkout) && $logo_qr_checkout}
            <ps-label-information>
                <img {if isset($logo_qr_checkout_size) && $logo_qr_checkout_size > 0}width="100%" style="max-width: {$logo_qr_checkout_size.0|escape:'htmlall':'UTF-8'}px"{/if} src="{$logo_qr_checkout|escape:'htmlall':'UTF-8'}?cache={math equation='rand()'}" />
            </ps-label-information>
            {/if}
        </div>
        <ps-panel-footer>
            <ps-panel-footer-submit title="{l s='Save changes' mod='mptoolspro'}" icon="process-icon-save" direction="right" name="submitPanel"></ps-panel-footer-submit>
        </ps-panel-footer>
    </ps-panel>
    <ps-panel icon="icon-cogs" header="{l s='MercadoPago Basic Checkout (Redirect Window)' mod='mptoolspro'}">
        <ps-switch name="mp_basic_enable"
            label="{l s='Actve payment with Basic Checkout' mod='mptoolspro'}"
            yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
            {if isset($mp_basic_enable) && $mp_basic_enable}active="true"{/if}></ps-switch>
        <div id="form_basic_div">
            <ps-input-text name="mp_basic_name"
                label="{l s='Display Name in Payment Checkout' mod='mptoolspro'}"
                help="{l s='Display Name in Payment Checkout' mod='mptoolspro'}" size="10"
                value="{if isset($mp_basic_name)}{$mp_basic_name|escape:'htmlall':'UTF-8'}{/if}"
                hint="{l s='Enter the display name in Payment Checkout' mod='mptoolspro'}"></ps-input-text>

            <ps-input-text name="max_expiration_hours"
                label="{l s='Number of hours to wait for the customer to pay before canceling the order' mod='mptoolspro'}"
                help="{l s='Permitted range: 1-72' mod='mptoolspro'}" size="10"
                value="{if isset($max_expiration_hours)}{$max_expiration_hours|escape:'htmlall':'UTF-8'}{else}48{/if}"
                fixed-width="lg"
                hint="{l s='Permitted range: 1-72' mod='mptoolspro'}"></ps-input-text>
                
            <ps-input-text name="fee"
                label="{l s='Percent of Commission charge to customer for using MercadoPago' mod='mptoolspro'}"
                help="{l s='Percent of Commission charge to customer for using MercadoPago' mod='mptoolspro'}" size="10"
                value="{if isset($fee)}{$fee|escape:'htmlall':'UTF-8'}{/if}"
                fixed-width="lg"
                hint="{l s='Percent of Commission charge to customer for using MercadoPago' mod='mptoolspro'}"></ps-input-text>

            <ps-input-text name="fee_amount"
                label="{l s='Amount of commission charge to customer for using MercadoPago, in' mod='mptoolspro'} {$settings.CURRENCY|escape:'htmlall':'UTF-8'}"
                help="{l s='Amount of commission charge to customer for using MercadoPago, in' mod='mptoolspro'} {$settings.CURRENCY|escape:'htmlall':'UTF-8'}" size="10"
                value="{if isset($fee_amount)}{$fee_amount|escape:'htmlall':'UTF-8'}{/if}"
                fixed-width="lg"
                hint="{l s='Amount of commission charge to customer for using MercadoPago, in' mod='mptoolspro'} {$settings.CURRENCY|escape:'htmlall':'UTF-8'}"></ps-input-text>

            <ps-switch name="commision_fee"
                label="{l s='Show price with fee on product sheet' mod='mptoolspro'}"
                yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
                {if isset($commision_fee) && $commision_fee}active="true"{/if}></ps-switch>

            <ps-switch name="mp_merchant_gateway_basic"
                label="{l s='Gateway Mode (Only Argentina and Colombia)' mod='mptoolspro'}"
                yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
                {if isset($mp_merchant_gateway_basic) && $mp_merchant_gateway_basic}active="true"{/if}></ps-switch>

            <ps-input-text name="min_amount_installments"
                label="{l s='Minimum amount of the order to activate payment in installments, in' mod='mptoolspro'} {$settings.CURRENCY|escape:'htmlall':'UTF-8'}"
                help="{l s='Minimum amount of the order to activate payment in installments, in' mod='mptoolspro'} {$settings.CURRENCY|escape:'htmlall':'UTF-8'}" size="10"
                value="{if isset($min_amount_installments)}{$min_amount_installments|escape:'htmlall':'UTF-8'}{/if}"
                fixed-width="lg"
                hint="{l s='Minimum amount of the order to activate payment in installments, in' mod='mptoolspro'} {$settings.CURRENCY|escape:'htmlall':'UTF-8'}"></ps-input-text>


            <ps-input-text name="max_installments"
                label="{l s='Maximum monthly payments to pay for the product' mod='mptoolspro'}"
                help="{l s='Permitted range: 1-36' mod='mptoolspro'}" size="10"
                value="{if isset($max_installments)}{$max_installments|escape:'htmlall':'UTF-8'}{/if}"
                fixed-width="lg"
                hint="{l s='Permitted range: 1-36' mod='mptoolspro'}"></ps-input-text>
            {if $ps_version < '1.7'}
                <input type="hidden" name="apply_fee_installment" value="0" />
                <input type="hidden" name="commision_fee_list_product" value="0" />
            {else}
                {if isset($settings.INSTALLMENT_FEE) && is_array($settings.INSTALLMENT_FEE)}
                    <ps-switch name="apply_fee_installment"
                        label="{l s='Apply fee by installment' mod='mptoolspro'}"
                        yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
                        {if isset($apply_fee_installment) && $apply_fee_installment}active="true"{/if}></ps-switch>
                        
                    <div id="form_fee_installment" {if !isset($apply_fee_installment) || not $apply_fee_installment}style="display:none"{/if}>
                        <ps-switch name="commision_fee_list_product"
                            label="{l s='Show price table with fee on product page' mod='mptoolspro'}"
                            yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
                            {if isset($commision_fee_list_product) && $commision_fee_list_product}active="true"{/if}></ps-switch>
                        {foreach $settings.INSTALLMENT_FEE as $value}

                            <ps-input-text name="fee_installment[{$value|escape:'htmlall':'UTF-8'}]"
                                label="{l s='Percent of fee charge to customer for using' mod='mptoolspro'} {$value|escape:'htmlall':'UTF-8'} {l s='installment' mod='mptoolspro'}"
                                help="{l s='Percent of fee charge to customer for using' mod='mptoolspro'} {$value|escape:'htmlall':'UTF-8'} {l s='installment' mod='mptoolspro'}" size="10"
                                value="{if isset($fee_installment[$value])}{$fee_installment[$value]|escape:'htmlall':'UTF-8'}{/if}"
                                fixed-width="lg"
                                hint="{l s='Percent of fee charge to customer for using' mod='mptoolspro'} {$value|escape:'htmlall':'UTF-8'} {l s='installment' mod='mptoolspro'}"></ps-input-text>

                        {/foreach}
                    </div>
                {else}
                    <input type="hidden" name="apply_fee_installment" value="0" />
                    <input type="hidden" name="commision_fee_list_product" value="0" />
                {/if}
            {/if}
           <!-- <ps-switch name="modal"
                label="{l s='Modal Window (By clicking on "Pay" MercadoPago window opens on the Same Page)' mod='mptoolspro'}"
                yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
                {if isset($modal) && $modal}active="true"{/if}></ps-switch>
                -->
            <input type="hidden" name="modal" value="0" />
            <ps-switch name="auto_return"
                label="{l s='Auto return when the payment is approved' mod='mptoolspro'}"
                yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
                {if isset($auto_return) && $auto_return}active="true"{/if}></ps-switch>
            <ps-checkboxes label="{l s='Exclude Payment Method' mod='mptoolspro'}">
                <ps-checkbox name="exclude_payments[bank_transfer]" {if isset($exclude_payments) and isset($exclude_payments.bank_transfer)}checked="true"{/if} value="1">
                    {l s='Bank Transfer' mod='mptoolspro'}
                </ps-checkbox>
                <ps-checkbox name="exclude_payments[atm]" value="1" {if isset($exclude_payments) and isset($exclude_payments.atm)}checked="true"{/if}>
                    {l s='ATM Bank Transfer' mod='mptoolspro'}
                </ps-checkbox>
                <ps-checkbox name="exclude_payments[ticket]" {if isset($exclude_payments) and isset($exclude_payments.ticket)}checked="true"{/if} value="1">
                    {l s='Ticket' mod='mptoolspro'}
                </ps-checkbox>
                <ps-checkbox name="exclude_payments[credit_card]" {if isset($exclude_payments) and isset($exclude_payments.credit_card)}checked="true"{/if} value="1">
                    {l s='Payment by credit card' mod='mptoolspro'}
                </ps-checkbox>
                <ps-checkbox name="exclude_payments[debit_card]" {if isset($exclude_payments) and isset($exclude_payments.debit_card)}checked="true"{/if} value="1">
                    {l s='Payment by debit card' mod='mptoolspro'}
                </ps-checkbox>
                <ps-checkbox name="exclude_payments[prepaid_card]" {if isset($exclude_payments) and isset($exclude_payments.prepaid_card)}checked="true"{/if} value="1">
                    {l s='Payment by prepaid card' mod='mptoolspro'}
                </ps-checkbox>
                {if $settings.ACCEPT_DIGITAL_CURRENCY}
                    <ps-checkbox name="exclude_payments[digital_currency]" {if isset($exclude_payments) and isset($exclude_payments.digital_currency)}checked="true"{/if} value="1">
                        {l s='Payment by digital currency (Bitcoin, etc..)' mod='mptoolspro'}
                    </ps-checkbox>
                {/if}
            </ps-checkboxes>
            <ps-radios label="{l s='Image for Order and Checkout on MercadoPago' mod='mptoolspro'}">
                <ps-radio name="image_for_order" value="custom" {if !isset($image_for_order) or $image_for_order == 'custom'}checked="true"{/if}>{l s='Custom Image' mod='mptoolspro'}</ps-radio>
                <ps-radio name="image_for_order" value="product" {if isset($image_for_order) and $image_for_order == 'product'}checked="true"{/if}>{l s='Use the first product image of the order' mod='mptoolspro'}</ps-radio>
            </ps-radios>
            <div id="logo_mercadopago_checkout" {if isset($image_for_order) && $image_for_order == 'product'}style="display:none">{/if}>
                <ps-input-file name="file_mercadopago_checkout"
                    label="{l s='Logo for Order and Checkout on MercadoPago' mod='mptoolspro'}"
                    help="{l s='Logo for Order and Checkout on MercadoPago' mod='mptoolspro'}" size="10"
                    hint="{l s='Logo for Order and Checkout on MercadoPago' mod='mptoolspro'}"></ps-input-file>
                {if isset($logo_mercadopago_checkout) && $logo_mercadopago_checkout}
                <ps-label-information>
                    <img {if isset($logo_mercadopago_checkout_size) && $logo_mercadopago_checkout_size > 0}width="100%" style="max-width: {$logo_mercadopago_checkout_size.0|escape:'htmlall':'UTF-8'}px"{/if} src="{$logo_mercadopago_checkout|escape:'htmlall':'UTF-8'}?cache={math equation='rand()'}" />
                </ps-label-information>
                {/if}
            </div>
            <ps-switch name="custom_payment_button"
                label="{l s='Use Custom Button Payment' mod='mptoolspro'}"
                yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
                {if isset($custom_payment_button) && $custom_payment_button}active="true"{/if}></ps-switch>
            <div id="custom_payment_button" {if !isset($custom_payment_button) or not $custom_payment_button}style="display:none"{/if}>
                <ps-input-file name="file_custom_button"
                    label="{l s='Attach Custom Button Image' mod='mptoolspro'}"
                    help="{l s='Attach Custom Button Image' mod='mptoolspro'}" size="10"
                    hint="{l s='Attach Custom Button Image' mod='mptoolspro'}"></ps-input-file>
                {if isset($custom_payment_button) && $custom_payment_button}
                <ps-label-information>
                    <img width="100%" style="max-width: {$custom_payment_button_size.0|escape:'htmlall':'UTF-8'}px" src="{$custom_payment_button|escape:'htmlall':'UTF-8'}?cache={math equation='rand()'}" />
                </ps-label-information>
                {/if}
            </div>
            {if $ps_version < '1.7'}
            <div id="default_payment_button" {if isset($custom_payment_button) && $custom_payment_button}style="display:none">{/if}>
                <ps-radios label="{l s='Color button' mod='mptoolspro'}">
                    <ps-radio name="style[b_color]" value="blue" {if !isset($style) or $style.b_color == 'blue'}checked="true"{/if}>{l s='Blue' mod='mptoolspro'}</ps-radio>
                    <ps-radio name="style[b_color]" value="orange" {if isset($style) and $style.b_color == 'orange'}checked="true"{/if}>{l s='Orange' mod='mptoolspro'}</ps-radio>
                    <ps-radio name="style[b_color]" value="red" {if isset($style) and $style.b_color == 'red'}checked="true"{/if}>{l s='Red' mod='mptoolspro'}</ps-radio>
                    <ps-radio name="style[b_color]" value="green" {if isset($style) and $style.b_color == 'green'}checked="true"{/if}>{l s='Green' mod='mptoolspro'}</ps-radio>
                    <ps-radio name="style[b_color]" value="lightblue" {if isset($style) and $style.b_color == 'lightblue'}checked="true"{/if}>{l s='LightBlue' mod='mptoolspro'}</ps-radio>
                    <ps-radio name="style[b_color]" value="grey" {if isset($style) and $style.b_color == 'grey'}checked="true"{/if}>{l s='Grey' mod='mptoolspro'}</ps-radio>
                </ps-radios>
                <ps-radios label="{l s='Size button' mod='mptoolspro'}">
                    <ps-radio name="style[b_size]" value="L" {if !isset($style) or !isset($style.b_size) or $style.b_size == 'L'}checked="true"{/if}>{l s='Large' mod='mptoolspro'}</ps-radio>
                    <ps-radio name="style[b_size]" value="M" {if isset($style) and $style.b_size == 'M'}checked="true"{/if}>{l s='Medium' mod='mptoolspro'}</ps-radio>
                    <ps-radio name="style[b_size]" value="S" {if isset($style) and $style.b_size == 'S'}checked="true"{/if}>{l s='Small' mod='mptoolspro'}</ps-radio>
                </ps-radios>
                <ps-radios label="{l s='Shape style button' mod='mptoolspro'}">
                    <ps-radio name="style[b_shape]" value="Sq" {if !isset($style) or !isset($style.b_shape) or $style.b_shape == 'Sq'}checked="true"{/if}>{l s='Square' mod='mptoolspro'}</ps-radio>
                    <ps-radio name="style[b_shape]" value="Rn" {if isset($style) and $style.b_shape == 'Rn'}checked="true"{/if}>{l s='Rounded' mod='mptoolspro'}</ps-radio>
                    <ps-radio name="style[b_shape]" value="Ov" {if isset($style) and $style.b_shape == 'Ov'}checked="true"{/if}>{l s='Oval' mod='mptoolspro'}</ps-radio>
                </ps-radios>
                <ps-radios label="{l s='Font style button' mod='mptoolspro'}">
                    <ps-radio name="style[b_font]" value="Ar" {if !isset($style) or !isset($style.b_font) or $style.b_font == 'Ar'}checked="true"{/if}>{l s='Arial' mod='mptoolspro'}</ps-radio>
                    <ps-radio name="style[b_font]" value="Tr" {if isset($style) and $style.b_font == 'Tr'}checked="true"{/if}>{l s='Trebuchet' mod='mptoolspro'}</ps-radio>
                    <ps-radio name="style[b_font]" value="Ge" {if isset($style) and $style.b_font == 'Ge'}checked="true"{/if}>{l s='Georgia' mod='mptoolspro'}</ps-radio>
                </ps-radios>
                <ps-radios label="{l s='Logos in button' mod='mptoolspro'}">
                    <ps-radio name="style[b_logo]" value="All" {if !isset($style) or !isset($style.b_logo) or $style.b_logo == 'All'}checked="true"{/if}>{l s='All payment methods' mod='mptoolspro'}</ps-radio>
                    <ps-radio name="style[b_logo]" value="On" {if isset($style) and $style.b_logo == 'On'}checked="true"{/if}>{l s='Only for immediate accreditation payment methods' mod='mptoolspro'}</ps-radio>
                </ps-radios>
            </div>
            {/if}
            
            {if $mercadoenvios_available}
                {if isset($api_me.shipping_modes) and in_array('me2', $api_me.shipping_modes)}
                    <ps-switch name="shipping_active"
                        label="{l s='Enable MercadoEnvios' mod='mptoolspro'}"
                        yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
                        {if isset($shipping_active) and $shipping_active}active="true"{/if}>
                    </ps-switch>
                    <div id="form_mercadoenvios" {if !isset($shipping_active) || not $shipping_active}style="display:none"{/if}>
                        <ps-radios label="{l s='Calculation mode' mod='mptoolspro'}">
                            <ps-radio name="shipping_calc_mode" value="sum_side" {if !isset($shipping_calc_mode) or $shipping_calc_mode == 'sum_side'}checked="true"{/if}>{l s='Use width and height longest of all. Adding depth of each product.' mod='mptoolspro'}</ps-radio>
                            <ps-radio name="shipping_calc_mode" value="longer_side" {if isset($shipping_calc_mode) and $shipping_calc_mode == 'longer_side'}checked="true"{/if}>{l s='Use the longer sides of each product.' mod='mptoolspro'}</ps-radio>
                        </ps-radios>
                        <ps-select name="exclude_client_groups[]" multiple="true" label="{l s='Exclude MercadoEnvios for this clients groups' mod='mptoolspro'}">
                            {foreach from=$client_groups item=val}
                                <option value="{$val.id_group|escape:'htmlall':'UTF-8'}" {if isset($exclude_client_groups) and in_array($val.id_group, $exclude_client_groups)}data-selected="true"{/if}>{$val.name|escape:'htmlall':'UTF-8'}</option>
                            {/foreach}
                        </ps-select>
                        <ps-switch name="ship_check_price"
                            label="{l s='Enable calculator of MercadoEnvios on product sheet' mod='mptoolspro'}"
                            yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
                            {if isset($ship_check_price) and $ship_check_price}active="true"{/if}></ps-switch>
                        <ps-switch name="create_manual_label"
                            label="{l s='Create label manually' mod='mptoolspro'}"
                            yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
                            {if isset($create_manual_label) and $create_manual_label}active="true"{/if}></ps-switch>
                        <ps-switch name="preparation_status"
                            label="{l s='Change status to Preparation in Progress when Shipping label is created' mod='mptoolspro'}"
                            yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
                            {if isset($preparation_status) and $preparation_status}active="true"{/if}></ps-switch>
                        <ps-input-text name="default_weight"
                            label="{l s='Weight default product (In grams)' mod='mptoolspro'}"
                            help="{l s='Only numbers value, for example: 100' mod='mptoolspro'}" size="10"
                            value="{if isset($default_weight)}{$default_weight|escape:'htmlall':'UTF-8'}{/if}"
                            hint="{l s='Only numbers value, for example: 100' mod='mptoolspro'}" fixed-width="lg"></ps-input-text>
                        <ps-input-text name="default_width"
                            label="{l s='Width default product (In centimeters)' mod='mptoolspro'}"
                            help="{l s='Only numbers value, for example: 10' mod='mptoolspro'}" size="10"
                            value="{if isset($default_width)}{$default_width|escape:'htmlall':'UTF-8'}{/if}"
                            hint="{l s='Only numbers value, for example: 10' mod='mptoolspro'}" fixed-width="lg"></ps-input-text>
                        <ps-input-text name="default_height"
                            label="{l s='Height default product (In centimeters)' mod='mptoolspro'}"
                            help="{l s='Only numbers value, for example: 10' mod='mptoolspro'}" size="10"
                            value="{if isset($default_height)}{$default_height|escape:'htmlall':'UTF-8'}{/if}"
                            hint="{l s='Only numbers value, for example: 10' mod='mptoolspro'}" fixed-width="lg"></ps-input-text>
                        <ps-input-text name="default_depth"
                            label="{l s='Depth default product (In centimeters)' mod='mptoolspro'}"
                            help="{l s='Only numbers value, for example: 10' mod='mptoolspro'}" size="10"
                            value="{if isset($default_depth)}{$default_depth|escape:'htmlall':'UTF-8'}{/if}"
                            hint="{l s='Only numbers value, for example: 10' mod='mptoolspro'}" fixed-width="lg"></ps-input-text>
                    </div>
                {else}
                    <ps-label-information>
                        <ps-alert-error><a href="{$settings.MPENVIOS_REGISTER_URL|escape:'htmlall':'UTF-8'}" target="_blank">{l s='Click here for active MercadoEnvios in your account' mod='mptoolspro'}</a></ps-alert-error>
                        <ps-alert-hint><a href="javascript:void($('#formKMP')[0].submit())">{l s='Reload this page if you have already registered successfully in MercadoEnvios.' mod='mptoolspro'}</a></ps-alert-error>
                    </ps-label-information>
                {/if}
            {/if}
        </div>
        <ps-panel-footer>
            <ps-panel-footer-submit title="{l s='Save changes' mod='mptoolspro'}" icon="process-icon-save" direction="right" name="submitPanel"></ps-panel-footer-submit>
        </ps-panel-footer>
    </ps-panel>
    <ps-panel icon="icon-cogs" header="{l s='MercadoPago Custom Checkout (Tokenizer)' mod='mptoolspro'}">
        <ps-switch name="mp_custom_enable"
            label="{l s='Actve payment with Custom Checkout (Tokenizer)' mod='mptoolspro'}"
            yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
            {if isset($mp_custom_enable) && $mp_custom_enable}active="true"{/if}></ps-switch>
        <div id="form_custom_div">
            <ps-input-text name="mp_custom_name"
                label="{l s='Display Name in Payment Checkout' mod='mptoolspro'}"
                help="{l s='Display Name in Payment Checkout' mod='mptoolspro'}" size="10"
                value="{if isset($mp_custom_name)}{$mp_custom_name|escape:'htmlall':'UTF-8'}{/if}"
                hint="{l s='Enter the display name in Payment Checkout' mod='mptoolspro'}"></ps-input-text>

            <ps-input-text name="fee_custom"
                label="{l s='Percent of Commission charge to customer for using MercadoPago' mod='mptoolspro'}"
                help="{l s='Percent of Commission charge to customer for using MercadoPago' mod='mptoolspro'}" size="10"
                value="{if isset($fee_custom)}{$fee_custom|escape:'htmlall':'UTF-8'}{/if}"
                fixed-width="lg"
                hint="{l s='Percent of Commission charge to customer for using MercadoPago' mod='mptoolspro'}"></ps-input-text>

            <ps-input-text name="fee_amount_custom"
                label="{l s='Amount of commission charge to customer for using MercadoPago, in' mod='mptoolspro'} {$settings.CURRENCY|escape:'htmlall':'UTF-8'}"
                help="{l s='Amount of commission charge to customer for using MercadoPago, in' mod='mptoolspro'} {$settings.CURRENCY|escape:'htmlall':'UTF-8'}" size="10"
                value="{if isset($fee_amount_custom)}{$fee_amount_custom|escape:'htmlall':'UTF-8'}{/if}"
                fixed-width="lg"
                hint="{l s='Amount of commission charge to customer for using MercadoPago, in' mod='mptoolspro'} {$settings.CURRENCY|escape:'htmlall':'UTF-8'}"></ps-input-text>

            <ps-switch name="commision_fee_custom"
                label="{l s='Show price with fee on product sheet' mod='mptoolspro'}"
                yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
                {if isset($commision_fee_custom) && $commision_fee_custom}active="true"{/if}></ps-switch>

            <ps-switch name="mp_merchant_gateway"
                label="{l s='Gateway Mode (Only Argentina and Colombia)' mod='mptoolspro'}"
                yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
                {if isset($mp_merchant_gateway) && $mp_merchant_gateway}active="true"{/if}></ps-switch>

            <ps-switch name="mp_binary_mode"
                label="{l s='Binary Mode' mod='mptoolspro'}"
                yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
                {if isset($mp_binary_mode) && $mp_binary_mode}active="true"{/if}></ps-switch>
            <input type="hidden" name="plan_enable" value="0" />
            <ps-switch name="plan_enable"
                label="{l s='Enable Plan for Payment' mod='mptoolspro'}"
                yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
                {if isset($plan_enable) && $plan_enable}active="true"{/if}></ps-switch>
            <div id="form_plan_div">
                <ps-switch name="plan_setting[by_default]"
                    label="{l s='Enable Plan for Payment by Default in All Product' mod='mptoolspro'}"
                    yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
                    {if isset($plan_setting) and isset($plan_setting.by_default) and $plan_setting.by_default}active="true"{/if}></ps-switch>

                <ps-radios label="{l s='Frequency Type' mod='mptoolspro'}">
                    <ps-radio name="plan_setting[frequency_type]" value="days" {if !isset($plan_setting) or !isset($plan_setting.frequency_type) or $plan_setting.frequency_type == 'days'}checked="true"{/if}>{l s='Days' mod='mptoolspro'}</ps-radio>
                    <ps-radio name="plan_setting[frequency_type]" value="months" {if isset($plan_setting) and isset($plan_setting.frequency_type) and $plan_setting.frequency_type == 'months'}checked="true"{/if}>{l s='Months' mod='mptoolspro'}</ps-radio>
                </ps-radios>

                <ps-input-text name="plan_setting[frequency]"
                            label="{l s='Amount of time (in days or months) for the execution of the next payment. (separated by comma for each frequency allowed)' mod='mptoolspro'}"
                            help="{l s='Only numbers value, for example: 12' mod='mptoolspro'}" size="10"
                            value="{if isset($plan_setting) and isset($plan_setting.frequency)}{$plan_setting.frequency|escape:'htmlall':'UTF-8'}{/if}"
                            hint="{l s='Only numbers value, for example: 12' mod='mptoolspro'}" fixed-width="lg"></ps-input-text>

                <ps-input-text name="plan_setting[repetitions]"
                            label="{l s='Quantity of payments to be done during the subscription validity (number of installments, separated by comma for each installments allowed, empty for infinity)' mod='mptoolspro'}"
                            help="{l s='Only numbers value, for example: 3,6,12' mod='mptoolspro'}" size="10"
                            value="{if isset($plan_setting) and isset($plan_setting.repetitions)}{$plan_setting.repetitions|escape:'htmlall':'UTF-8'}{/if}"
                            hint="{l s='Only numbers value, for example: 3,6,12' mod='mptoolspro'}" fixed-width="lg"></ps-input-text>
                <input name="plan_setting[trail]" value="0" type="hidden" />
                <input name="plan_setting[frequency_trail]" value="1" type="hidden" />
                <input name="plan_setting[frequency_type_trail]" value="months" type="hidden" />
<!--
                <ps-switch name="plan_setting[trail]"
                    label="{l s='Enable Trail Period to give the service for free (bonus period)' mod='mptoolspro'}"
                    yes="{l s='Yes' mod='mptoolspro'}" no="{l s='No' mod='mptoolspro'}"
                    {if isset($plan_setting) and isset($plan_setting.trail) and $plan_setting.trail}active="true"{/if}></ps-switch>

                <ps-radios label="{l s='Indicates the period of time. Might be: days or months' mod='mptoolspro'}">
                    <ps-radio name="plan_setting[frequency_type_trail]" value="days" {if !isset($plan_setting) or !isset($plan_setting.frequency_type_trail) or $plan_setting.frequency_type_trail == 'days'}checked="true"{/if}>{l s='Days' mod='mptoolspro'}</ps-radio>
                    <ps-radio name="plan_setting[frequency_type_trail]" value="months" {if isset($plan_setting) and isset($plan_setting.frequency_type_trail) and $plan_setting.frequency_type_trail == 'months'}checked="true"{/if}>{l s='Months' mod='mptoolspro'}</ps-radio>
                </ps-radios>

                <ps-input-text name="plan_setting[frequency_trail]"
                            label="{l s='Amount of time (in days or months) for the free trial period' mod='mptoolspro'}"
                            help="{l s='Only numbers value, for example: 1' mod='mptoolspro'}" size="10"
                            value="{if isset($plan_setting) and isset($plan_setting.frequency_trail)}{$plan_setting.frequency_trail|escape:'htmlall':'UTF-8'}{/if}"
                            hint="{l s='Only numbers value, for example: 1' mod='mptoolspro'}" fixed-width="lg"></ps-input-text>
-->
            </div>
            <ps-label-information>
                <ps-alert-warn>
                    <b>{l s='Search your Public and Secret Key here' mod='mptoolspro'}:</b>
                {foreach from=$data_settings item=country}
                    <a href="{$country.PUBLICKEY_URL|escape:'htmlall':'UTF-8'}" target="_blank">{$country.NAME|escape:'htmlall':'UTF-8'}</a>
                {/foreach}
                </ps-alert-warn>
            </ps-label-information>
        </div>
        <ps-panel-footer>
            <ps-panel-footer-submit title="{l s='Save changes' mod='mptoolspro'}" icon="process-icon-save" direction="right" name="submitPanel"></ps-panel-footer-submit>
        </ps-panel-footer>
    </ps-panel>
    {/if}
</form>
