{*
* Template para MercadoPago
*
* @author    Kijam
* @copyright 2020 Kijam
* @license   Commercial use allowed (Non-assignable & non-transferable),
*            can modify source-code but cannot distribute modifications
*            (derivative works).
*}
{extends file='page.tpl'}
{block name='page_content'} 
{if $el}
    <center><h2>{$el.name|escape:'htmlall':'UTF-8'} ({$el.n_cards|escape:'htmlall':'UTF-8'})</h2></center>
    <div class="list_icons">
        <div onclick="addCards(this)" class="link_search_card" data-name="{$el.name|escape:'htmlall':'UTF-8'}" data-link="{$el.link_search_card|escape:'htmlall':'UTF-8'}"><i class="material-icons">note_add</i> Añadir Productos</div>
    </div>
    {if $el.n_cards > 0}
    <div class="list_card_products">
        <ul class="list_product_gallery">
        {foreach from=$el.p_list item=$product}
            <li data-thumb="{$product.image|escape:'htmlall':'UTF-8'}" data-src="{$product.image|escape:'htmlall':'UTF-8'}">
                <center><a href="{$product.link|escape:'htmlall':'UTF-8'}" class="ncards{$product.cards|escape:'htmlall':'UTF-8'}" target="_blank">
                {if $product.image}
                <img src="{$product.image|escape:'htmlall':'UTF-8'}" class="pcard card{$foo|escape:'htmlall':'UTF-8'}" />
                {/if}
                </a><br /><small>{$product.name|escape:'htmlall':'UTF-8'}</small><br />
                          <em><b>En el Primer pago:</b> {$product.qty_first_time|escape:'htmlall':'UTF-8'}</em><br />
                          <em><b>En los pagos recurrentes:</b> {$product.qty_recurring_paymen|escape:'htmlall':'UTF-8't}</em><br />
                          {if $product.qty_recurring_payment > 0}
                            <em>Este producto se enviara y cobrara cada {$product.valid_frequency[0]|escape:'htmlall':'UTF-8'} {if $product.frequency_type=='months'}mes(es){else}dia(s){/if} en {$product.valid_repetitions[0]|escape:'htmlall':'UTF-8'} ocacion(es).</em><br />
                          {/if}
                <div class="list_icons">
                    <div onclick="deleteCard(this)" class="link_delete" data-link="{$product.link_delete|escape:'htmlall':'UTF-8'}" data-name="{$product.name|escape:'htmlall':'UTF-8'}"><i class="material-icons">delete_forever</i></div>
                </div></center>
            </li>
        {/foreach}
        </ul>
    </div>
    {/if}
    <script>
        function deleteCard(div) {
            var $ = jQuery;
            var link = $(div).attr('data-link');
            var name = $(div).attr('data-name');
            confirmDialogCard('{l s='¿Deseas eliminar este producto del pack?' mod='mptoolspro'} '+name+'?', false, link, function(error) {
                if (!error) $(div).closest('li').remove();
            }, false);
        }
        var timeoutChecker = false, xhrChecker = false;
        function addCards(div) {
            var $ = jQuery;
            var link = $(div).attr('data-link');
            var name = $(div).attr('data-name');
            confirmDialogCard(
                '{l s='Ingresa el nombre, referencia o palabra clave del producto' mod='mptoolspro'}',
                '<div class="row"><div class="col-sm-3"><b>{l s='Buscar' mod='mptoolspro'}</b></div><div class="col-sm-9" style="position:relative"><input type="input" class="form-control" data-link="'+link+'" id="name_search_cards_txt" /><div id="list_result" style="display:none;"></div></div></div>'+
                '<div class="row"><input name="name_search_cards" type="hidden" /><div class="col-sm-12" id="list_new_cards"></div></div>',
                false,
                false, 
                false,
                function() {
                    location.reload(true);
                }
            );
            $('#name_search_cards_txt').keyup(function() {
                if (timeoutChecker) {
                    clearTimeout(timeoutChecker);
                    timeoutChecker = false;
                }
                if (xhrChecker) {
                    xhrChecker.abort();
                    xhrChecker = false;
                }
                if ($('#name_search_cards_txt').val().length < 3) {
                    $('#list_result').hide();
                    return;
                }
                $('#list_result').show();
                $('#list_result').html('Cargando...');
                timeoutChecker = setTimeout(function(){
                    timeoutChecker = false;
                    xhrChecker = $.ajax({
                        type: "POST",
                        url: $('#name_search_cards_txt').attr('data-link'),
                        data: "search_card_keyword="+encodeURI($('#name_search_cards_txt').val()),
                        success: function(msg){
                            xhrChecker = false;
                            var d = JSON.parse(msg);
                            console.log(d);
                            if (d.error && !d.isEmpty) {
                                $('#list_result').html('<b style="color: #148008">'+d.error+'</b>');
                                timeoutChecker = setTimeout(function(){
                                    $('#list_result').hide();
                                    timeoutChecker = false;
                                }, 5000);
                                return;
                            }
                            var html = '';
                            for (var i in d.result) {
                                var p = d.result[i];
                                html += '<div class="row"><div class="col-md-4"><img src="'+p.mini_image+'" /></div>';
                                html += '<div class="col-md-8"><b>'+p.name+'</b>';
                                html += '<br /><b>Recurrencia:</b> Este producto se enviara y cobrara cada '+p.frequency[0]+' '+p.frequency_type+' en '+p.repetitions[0]+' ocaciones';
                                html += '<br />Se enviaran <span class="ccards" id="ccards_cf'+p.id_product+'">'+p.c_cards_cf+'</span> en el primer pago y <span class="ccards" id="ccards_cr'+p.id_product+'">'+p.c_cards_cr+'</span> en los siguientes pagos.<br /><input type="button" onclick="addCard('+d.id_suscription_pack+', '+p.id_product+', 1)" class="btn btn-success" value="Añadir al Primer Pago" /> <input type="button" onclick="addCard('+d.id_suscription_pack+', '+p.id_product+', 0)" class="btn btn-success" value="Añadir al Pago Recurrente" /></div>';
                                html += '</div>';
                            }
                            $('#list_result').html(html);
                        }
                    });
                }, 1000);
            });
        }
        function addCard(id_suscription_pack, id_product, in_first_payment) {
            jQuery.post('{$home_list_card|escape:'htmlall':'UTF-8'}', {
                id_product: id_product,
                in_first_payment: in_first_payment,
                action: 'addCard',
                id_suscription_pack: id_suscription_pack
             }, function( data ) {
                console.log( data );
                if (data.error) alert(data.error);
                else {
                    alert('{l s='Añadido con exito' mod='mptoolspro'}');
                    if (in_first_payment) {
                        var c = $('#ccards_cf'+id_product).html()*1 + 1;
                        $('#ccards_cf'+id_product).html(c);
                    } else {
                        var c = $('#ccards_cr'+id_product).html()*1 + 1;
                        $('#ccards_cr'+id_product).html(c);
                    }
                }
            }, "json");
        }
        {if $el.n_cards == 0}
        var autonew = setInterval(function(){
            if (typeof jQuery == 'undefined') return;
            clearInterval(autonew);
            jQuery('.link_search_card').trigger('click');
        }, 1000); 
        {/if}
    </script>
    <div class="modal fade card-modal" role="dialog" id="card-modal">
      <div class="modal-dialog  modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="{l s='Cerrar' mod='mptoolspro'}">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
                <h4 id="modal_message"></h4>
                <div id="modal_content"></div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-primary">{l s='Aceptar' mod='mptoolspro'}</button>
            <button type="button" class="btn btn-secondary" data-dismiss="modal">{l s='Cerrar' mod='mptoolspro'}</button>
          </div>
        </div><!-- /.modal-content -->
      </div><!-- /.modal-dialog -->
    </div><!-- /.modal -->
    <br />
    <style>
        #list_result > .row {
            margin-bottom: 5px;
        }
        #list_result {
            width: 100%;
        }
        span.ccards {
            font-weight: bold;
            color: red;
        }
        .card-block > .list_icons>div {
            padding: 10px;
        }
    </style>
{else}
    <h1>{l s='Este pack no esta disponible en este momento' mod='mptoolspro'}!.</h1>
{/if}
{/block}