<?php
/**
* Modulo MercadoPago Tools Pro
*
* @author    Kijam
* @copyright 2020 Kijam
* @license   Commercial use allowed (Non-assignable & non-transferable),
*            can modify source-code but cannot distribute modifications
*            (derivative works).
*/

class AdminSuscriptionPacksController extends ModuleAdminController
{
    private $module_name = 'mptoolspro';
    private $module_instance;
    public function __construct()
    {
        parent::__construct();
        $this->context = Context::getContext();
        $this->module_instance = Module::getInstanceByName($this->module_name);
        $this->bootstrap = true; // use Bootstrap CSS
        $this->table = UKijam::DB_PREFIX.'_suscription_packs'; // SQL table name, will be prefixed with _DB_PREFIX_
        $this->identifier = 'id'; // SQL column to be used as primary key
        $this->className = 'SuscriptionPacks'; // PHP class name
        $this->allow_export = false; // allow export in CSV, XLS..
        $this->_defaultOrderBy = 'a.name'; // the table alias is always `a`
        $this->_defaultOrderWay = 'DESC';
        $this->_where = 'AND a.id_shop = '.(int)Context::getContext()->shop->id;
        $this->fields_list = array(
            'id' => array(
                'title' => 'ID',
                'class' => 'fixed-width-xs'
            ),
            'name' => array('title' => 'Nombre'),
            'free_shipping_first_time' => array(
                'title' => 'Primer Envio Gratis',
                'align' => 'center',
                'type' => 'bool',
                'callback' => 'printFSFirst',
                'orderby' => true,
            ),
            'free_shipping_recurring_payment' => array(
                'title' => 'Envio Gratis Recurrente',
                'align' => 'center',
                'type' => 'bool',
                'callback' => 'printFSRecurring',
                'orderby' => true,
            ),
            'is_public' => array(
                'title' => 'Publico',
                'align' => 'center',
                'type' => 'bool',
                'callback' => 'printIsPublic',
                'orderby' => true,
            ),
            'date_add' => array(
                'title' => 'Fecha de Creación',
                'type'=>'datetime'
            ),
            'id_shop' => array(
                'title' => ' ',
                'align' => 'center',
                'callback' => 'printPreview',
                'orderby' => false,
                'search' => false,
                'remove_onclick' => true,
            ),
        );
        $this->bulk_actions = array(
            'delete' => array(
                'text' => $this->l('Delete selected'),
                'confirm' => $this->l('Delete selected items?'),
                'icon' => 'icon-trash'
            )
        );
        $this->addRowAction('edit');
        $this->addRowAction('delete');
        $this->fields_form = array(
        'legend' => array(
            'title' => 'Packs de suscripción para MercadoPago Tools Pro',
            'icon' => 'icon-list-ul'
        ),
        'input' => array(
            array(
                'name' => 'name',
                'type' => 'text',
                'label' => 'Nombre',
                'required' => true
            ),
            array(
                'type' => 'textarea',
                'label' => 'Descripción',
                'name' => 'description',
                'cols' => 60,
                'rows' => 10,
                'class' => 'rte',
                'autoload_rte' => true,
                'hint' => 'Caracteres Invalidos: <>;=#{}'
            ),
            array(
                'type' => 'switch',
                'label' => 'Publico',
                'name' => 'is_public',
                'required' => false,
                'class' => 't',
                'is_bool' => true,
                'values' => array(
                    array(
                        'id' => 'active_on',
                        'value' => 1,
                        'label' => 'Activar',
                    ),
                    array(
                        'id' => 'active_off',
                        'value' => 0,
                        'label' => 'Desactivar',
                    ),
                ),
                'hint' => 'Este pack sera visible en la pagina',
            ),
            array(
                'type' => 'switch',
                'label' => 'Primer Envio Gratis',
                'name' => 'free_shipping_first_time',
                'required' => false,
                'class' => 't',
                'is_bool' => true,
                'values' => array(
                    array(
                        'id' => 'active_on',
                        'value' => 1,
                        'label' => 'Activar',
                    ),
                    array(
                        'id' => 'active_off',
                        'value' => 0,
                        'label' => 'Desactivar',
                    ),
                ),
                'hint' => 'El Primer Envio Gratis sera gratis',
            ),
            array(
                'type' => 'switch',
                'label' => 'Envio Gratis Recurrente',
                'name' => 'free_shipping_recurring_payment',
                'required' => false,
                'class' => 't',
                'is_bool' => true,
                'values' => array(
                    array(
                        'id' => 'active_on',
                        'value' => 1,
                        'label' => 'Activar',
                    ),
                    array(
                        'id' => 'active_off',
                        'value' => 0,
                        'label' => 'Desactivar',
                    ),
                ),
                'hint' => 'Desde el 2do pago en adelante todos los envios seran gratis',
            ),
        ),
        'submit' => array(
            'title' => 'Guardar',
        )
        );
    }
    public function printFSFirst($value, $pack)
    {
        return '<a class="list-action-enable '.($value ? 'action-enabled' : 'action-disabled').'"
                    href="index.php?'.htmlspecialchars('controller=AdminSuscriptionPacks&id='
            .(int)$pack['id'].'&toggleFSFirstPack&token='.Tools::getAdminTokenLite('AdminSuscriptionPacks')).'">
                '.($value ? '<i class="icon-check"></i>' : '<i class="icon-remove"></i>').
            '</a>';
    }
    public function printFSRecurring($value, $pack)
    {
        return '<a class="list-action-enable '.($value ? 'action-enabled' : 'action-disabled').'"
                    href="index.php?'.htmlspecialchars('controller=AdminSuscriptionPacks&id='
            .(int)$pack['id'].'&toggleFSRecurringPack&token='.Tools::getAdminTokenLite('AdminSuscriptionPacks')).'">
                '.($value ? '<i class="icon-check"></i>' : '<i class="icon-remove"></i>').
            '</a>';
    }
    public function printIsPublic($value, $pack)
    {
        return '<a class="list-action-enable '.($value ? 'action-enabled' : 'action-disabled').'"
                    href="index.php?'.htmlspecialchars('controller=AdminSuscriptionPacks&id='
            .(int)$pack['id'].'&togglePublicPack&token='.Tools::getAdminTokenLite('AdminSuscriptionPacks')).'">
                '.($value ? '<i class="icon-check"></i>' : '<i class="icon-remove"></i>').
            '</a>';
    }
    public function printPreview($value, $pack)
    {
        $link = $this->context->link->getModuleLink(
            $this->module_name,
            'page',
            array('action' => 'show', 'tk' => md5(_COOKIE_KEY_.$pack['id']), 'id' => $pack['id'])
        );
        return '<a class="btn btn-success" href="'.$link.'" target="_blank">Añadir/Editar Productos</a>';
    }
    public function initProcess()
    {
        parent::initProcess();
        $id = (int)Tools::getValue('id');
        if (Tools::isSubmit('toggleFSFirstPack') && $id > 0) {
            $m = new SuscriptionPacks($this->id_object);
            $m->is_public = !$m->is_public;
            $m->save();
        } elseif (Tools::isSubmit('toggleFSRecurringPack') && $id > 0) {
            $m = new SuscriptionPacks($this->id_object);
            $m->is_public = !$m->is_public;
            $m->save();
        } elseif (Tools::isSubmit('togglePublicPack') && $id > 0) {
            $m = new SuscriptionPacks($this->id_object);
            $m->is_public = !$m->is_public;
            $m->save();
        }
    }
}
