<?php
/**
* Modulo MercadoPago Tools Pro
*
* @author    Kijam
* @copyright 2020 Kijam
* @license   Commercial use allowed (Non-assignable & non-transferable),
*            can modify source-code but cannot distribute modifications
*            (derivative works).
*/

class MPToolsProPageModuleFrontController extends ModuleFrontController
{
    private $config;
    public function __construct()
    {
        parent::__construct();
    }

    private function initConfig()
    {
        if ($this->config != null) {
            return;
        }
        $this->context = Context::getContext();
        $this->id_shop = Shop::getContextShopID();
        $this->id_shop_group = Shop::getContextShopGroupID();
        $this->module_name = $this->module->name;
        $this->config = (array)Tools::jsonDecode(Configuration::get(
            $this->module_name.'c_config',
            null,
            $this->id_shop_group,
            $this->id_shop
        ), true);
        $this->context = Context::getContext();
    }
    
    /**
     * @see FrontController::initContent()
     */
    public function initContent()
    {
        $this->initConfig();
        $action = Tools::getValue('action');
        $tk = Tools::getValue('tk');
        //$new_name = trim((string)Tools::getValue('name'));
        $cover_name = trim((string)Tools::getValue('cover_name'));
        if (!empty($cover_name)) {
            $matches = null;
            $r = preg_match('/^\\/modules\\/mptoolspro\\/views\\/img\\/[0-9a-zA-Z_-]+\\.jpg$/', $cover_name, $matches);
            if (!$r || !$matches || count($matches) < 1) {
                $cover_name = '';
            }
        }
        $in_first_payment = (bool)Tools::getValue('in_first_payment');
        $id_product = (int)Tools::getValue('id_product');
        $id_suscription_pack = (int)Tools::getValue('id_suscription_pack');
        $active_by_default = (bool)$this->config['plan_setting']['by_default'];
        $checked = (bool)Configuration::get(
            $this->module_name.'_disabled_plan_'.$id_product,
            null,
            $this->id_shop_group,
            $this->id_shop
        );
        $disabled_plan = true;
        if ($active_by_default) {
            $disabled_plan = false;
            if ($checked) {
                $disabled_plan = true;
            }
        } else {
            $disabled_plan = true;
            if ($checked) {
                $disabled_plan = false;
            }
        }
        $id_customer = (int)$this->context->cookie->id_customer;
        $result = array('error' => false, 'result' => false);
        switch ($action) {
            case 'searchCard':
                $id_suscription_pack = Tools::getValue('id_search_card');
                $keyword = trim(Tools::getValue('search_card_keyword'));
                if (!$keyword || Tools::strlen($keyword) < 3) {
                    die(Tools::jsonEncode(array(
                        'error' => 'Busqueda esta vacia',
                        'isEmpty' => true,
                        'data' => $_POST
                    )));
                }
                $exists = (int)Db::getInstance()->getValue('
                    SELECT m.id FROM `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_suscription_packs` m
                    WHERE
                        m.`id_shop` = '.(int)$this->id_shop.' AND
                        m.`id` = '.(int)$id_suscription_pack);
                if (!$exists) {
                    die(Tools::jsonEncode(array(
                        'error' => 'Pack no encontrado',
                        'isEmpty' => false,
                        'data' => $_POST
                    )));
                }
                $result = Search::find($this->context->language->id, $keyword, 1, 5);
                if (!$result || $result['total'] == 0) {
                    die(Tools::jsonEncode(array(
                        'error' => 'No se encontron registros',
                        'isEmpty' => false,
                        'result' => $result, 'data' => $_POST
                    )));
                } else {
                    $r = array(); 
                    $plan_setting = $this->config['plan_setting'];
                    foreach ($result['result'] as $row) {
                        $disabled_plan = true;
                        $checked = (bool)Configuration::get(
                            $this->module_name.'_disabled_plan_'.$row['id_product'],
                            null,
                            $this->id_shop_group,
                            $this->id_shop
                        );
                        if ($active_by_default) {
                            $disabled_plan = false;
                            if ($checked) {
                                $disabled_plan = true;
                            }
                        } else {
                            $disabled_plan = true;
                            if ($checked) {
                                $disabled_plan = false;
                            }
                        }
                        $custom_plan = (bool)Configuration::get(
                            $this->module_name.'_custom_plan_'.$row['id_product'],
                            null,
                            $this->id_shop_group,
                            $this->id_shop
                        );
                        if ($custom_plan) {
                            $custom_setting = (array)Tools::jsonDecode(Configuration::get(
                                $this->module_name.'_custom_setting_'.$row['id_product'],
                                null,
                                $this->id_shop_group,
                                $this->id_shop
                            ), true);
                        } else {
                            $custom_setting = $plan_setting;
                        }
                        $valid_frequency = explode(',', $custom_setting['frequency']);
                        $valid_repetitions = explode(',', $custom_setting['repetitions']);
                        $frequency_type = $custom_setting['frequency_type'];
                        //$max_card = 1;
                        if (!$disabled_plan) {
                            $images = Product::getCover($row['id_product']);
                            $row['custom_plan'] = $custom_plan;
                            $row['frequency'] = $valid_frequency;
                            $row['repetitions'] = $valid_repetitions;
                            $row['frequency_type'] = $frequency_type;
                            $row['c_cards_cf'] = (int)Db::getInstance()->getValue('
                                SELECT sum(c.qty_first_time) as c
                                FROM `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_sproducts` c
                                WHERE
                                    c.`id_product` = '.(int)$row['id_product'].' AND
                                    c.`id_suscription_pack` = '.(int)$id_suscription_pack.' GROUP BY c.`id_product`');
                            $row['c_cards_cr'] = (int)Db::getInstance()->getValue('
                                SELECT sum(c.qty_recurring_payment) as c
                                FROM `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_sproducts` c
                                WHERE
                                    c.`id_product` = '.(int)$row['id_product'].' AND
                                    c.`id_suscription_pack` = '.(int)$id_suscription_pack.' GROUP BY c.`id_product`');
                            $row['image_link'] = $this->context->link->getImageLink(
                                $row['link_rewrite'],
                                $images['id_image'],
                                ImageType::getFormatedName('menu')
                            );
                            $row['mini_image'] = $this->context->link->getImageLink(
                                $row['link_rewrite'],
                                $images['id_image'],
                                ImageType::getFormatedName('small')
                            );
                            $r[] = $row;
                        }
                    }
                    if (count($r) > 0) {
                        die(Tools::jsonEncode(array(
                            'error' => false,
                            'id_suscription_pack' => $id_suscription_pack,
                            'isEmpty' => false,
                            'result' => $r,
                            'data' => $_POST
                        )));
                    } else {
                        die(Tools::jsonEncode(
                            array('error' => 'No se encontron registros', 'isEmpty' => false, 'data' => $_POST)
                        ));
                    }
                }
                break;
            case 'deleteCard':
                $exists = (int)Db::getInstance()->getValue('
                    SELECT m.id FROM `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_suscription_packs` m
                    WHERE
                        m.`id_shop` = '.(int)$this->id_shop.' AND
                        m.`id` = '.(int)$id_suscription_pack);
                if ($exists) {
                    $r = Db::getInstance()->Execute('DELETE FROM `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_sproducts`
                        WHERE id_product = '.(int)Tools::getValue('id_product').' AND
                              `id_suscription_pack` = '.(int)$id_suscription_pack);
                    die(Tools::jsonEncode(
                        array('error' => !$r?'No se pudo eliminar la carta, intente mas tarde...':false)
                    ));
                }
                die(Tools::jsonEncode(array('error' => 'No se encontro el registro')));
            case 'addCardToNew':
            case 'addCard':
                $exists = (int)Db::getInstance()->getValue('
                    SELECT m.id FROM `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_suscription_packs` m
                    WHERE
                        m.`id_shop` = '.(int)$this->id_shop.' AND
                        m.`id` = '.(int)$id_suscription_pack);
                if (!$id_product) {
                    $result['error'] = 'El producto es requerido';
                } elseif (!$id_suscription_pack && $action == 'addCard') {
                    $result['error'] = 'Debes indicar un pack';
                } elseif (!$exists) {
                    $result['error'] = 'Este pack no existe';
                } else {
                    $product = new Product($id_product);
                    //$max_card = 1;
                    if ($disabled_plan) {
                        $result['error'] = 'El producto no esta permitido ser añadido a una suscripción';
                    } elseif (!$product->active) {
                        $result['error'] = 'El producto no esta activo';
                    }
                    /* elseif ($id_suscription_pack && (int)Db::getInstance()->getValue('
                        SELECT count(c.id) as c FROM `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_sproducts` c
                        WHERE
                            c.`id_product` = '.(int)$product->id.' AND
                            c.`id_suscription_pack` = '.(int)$id_suscription_pack.'
                        GROUP BY c.`id_product`') >= $max_card) {
                        $result['error'] = 'El producto ya existe en esta suscripción';
                    } */
                }
                if ($result['error']) {
                    die(Tools::jsonEncode($result));
                }
                break;
            case 'show':
                $list = false;
                if (Tools::isSubmit('id')) {
                    $list = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('
                        SELECT
                            m.*,
                            GROUP_CONCAT(c.id_product SEPARATOR \',\') id_product,
                            IF(c.id_suscription_pack IS NULL, 0, count(*)) n_cards
                        FROM `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_suscription_packs` m
                        LEFT JOIN `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_sproducts` c ON m.id = c.id_suscription_pack
                        WHERE
                            m.`id_shop` = '.(int)$this->id_shop.' AND
                            m.`id` = '.(int)Tools::getValue('id').'
                        GROUP BY m.id');
                    if ($list) {
                        $tk = Tools::isSubmit('tk') && md5(_COOKIE_KEY_.$list[0]['id']) == Tools::getValue('tk');
                        if (!$tk) {
                            $list = false;
                        }
                    }
                    $this->getProducts($list);
                }
                $this->context->smarty->assign(array(
                    'el' => count($list)?$list[0]:false,
                    'owner' => false,
                    'home_list_card' => $this->context->link->getModuleLink(
                        $this->module_name,
                        'page',
                        array('tk' => $tk)
                    )
                ));
                parent::initContent();
                $this->setTemplate('module:'.$this->module_name.'/views/templates/front/page_packs.tpl');
                return;
        }
        switch ($action) {
            case 'addCardToNew':
            case 'addCard':
                $exists = (int)Db::getInstance()->getValue('
                    SELECT m.id FROM `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_sproducts` m
                    WHERE
                        m.`id_product` = '.(int)$id_product.' AND
                        m.`id_suscription_pack` = '.(int)$id_suscription_pack);
                $s = $in_first_payment?'qty_first_time':'qty_recurring_payment';
                if ($exists) {
                    $r = Db::getInstance()->Execute('UPDATE `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_sproducts` SET
                            `'.$s.'` = `'.$s.'` + 1
                        WHERE
                            `id_product` = '.(int)$id_product.' AND
                            `id_suscription_pack` = '.(int)$id_suscription_pack);
                } else {
                    $r = Db::getInstance()->Execute('INSERT INTO `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_sproducts`
                        (`id_suscription_pack`, `id_product`, `'.$s.'`)
                        VALUES
                        ('.(int)$id_suscription_pack.', '.(int)$id_product.', 1)');
                }
                if ($r) {
                    $list = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('
                        SELECT m.*, IF(c.id_suscription_pack IS NULL, 0, count(*)) n_cards
                        FROM `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_suscription_packs` m
                        LEFT JOIN `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_sproducts` c ON m.id = c.id_suscription_pack
                        WHERE
                            m.`id` = '.(int)$id_suscription_pack.'
                        GROUP BY m.id');
                    $result['result'] = $list[0];
                } else {
                    $result['error'] = 'No se pudo añadir el producto al pack';
                }
                die(Tools::jsonEncode($result));
        }
        $is_full = Tools::getValue('action') == 'showFull';
        $orderby = '';
        $dir = Tools::getValue('dir') == 'ASC'?'ASC':'DESC';
        switch (Tools::getValue('orderby')) {
            case 'views':
                $orderby = 'm.`views` '.$dir;
                break;
            case 'cloned':
                $orderby = 'm.`cloned` '.$dir;
                break;
            case 'shared':
                $orderby = 'm.`shared` '.$dir;
                break;
            case 'created_at':
            default:
                $orderby = 'm.`created_at` '.$dir;
                break;
        }
        $page = (int)Tools::getValue('p');
        $num_rows = (int)Tools::getValue('r');
        if (!$num_rows) {
            $num_rows = 24;
        }
        if ($num_rows < 6) {
            $num_rows = 6;
        }
        if ($num_rows > 48) {
            $num_rows = 48;
        }
        $list_c = $is_full || $id_customer > 0?((int)Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue('SELECT count(*) as c
            FROM `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_suscription_packs` m
            WHERE
                m.`id_shop` = '.(int)$this->id_shop.'
                '.($is_full?'
                    AND m.`is_public` = 1
                    AND m.`admin_reviewed` = 1
                ':'
                    AND m.`id_user` = '.(int)$id_customer))):0;
        $list = $is_full || $id_customer > 0?Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('
            SELECT
                m.*,
                GROUP_CONCAT(c.id_product SEPARATOR \',\') id_product,
                IF(c.id_suscription_pack IS NULL, 0, count(*)) n_cards
            FROM `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_suscription_packs` m
            LEFT JOIN `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_sproducts` c ON m.id = c.id_suscription_pack
            WHERE
                m.`id_shop` = '.(int)$this->id_shop.'
                '.($is_full?'AND m.`is_public` = 1 AND m.`admin_reviewed` = 1':'AND m.`id_user` = '.(int)$id_customer).'
            GROUP BY m.id
            ORDER BY '.$orderby.'
            LIMIT '.(int)($page*$num_rows).', '.(int)$num_rows):false;
        $this->getProducts($list);
        $this->context->smarty->assign(array(
            'list' => $list,
            'list_c' => $list_c,
            'page' => $page,
            'num_rows' => $num_rows,
            'orderby' => Tools::getValue('orderby'),
            'dir' => $dir,
            'max_page' => ceil($list_c/$num_rows),
            'is_full' => $is_full,
            'home_list_card' => $this->context->link->getModuleLink($this->module_name, 'page', array('tk' => $tk)),
            'link_paginator' => $this->context->link->getModuleLink($this->module_name, 'page', array(
                'p' => 'PAGE',
                'r' => 'NUM_ROWS',
                'orderby' => 'ORDER_BY',
                'dir' => 'DIR',
                'tk' => $tk,
                'action' => Tools::getValue('action'),
            )),
        ));
        $this->display_column_left = false;
        $this->display_column_right = false;
        parent::initContent();
        $this->display_column_left = false;
        $this->display_column_right = false;
        $this->setTemplate('module:'.$this->module_name.'/views/templates/front/page_packs.tpl');
    }
    private function getProducts(&$list)
    {
        //$id_customer = (int)$this->context->cookie->id_customer;
        $tk = Tools::getValue('tk');
        if ($list && count($list) > 0) {
            $plan_setting = $this->config['plan_setting'];
            foreach ($list as &$el) {
                $owner = true;
                $el['link'] = $this->context->link->getModuleLink(
                    $this->module_name,
                    'page',
                    array('tk' => $tk, 'action' => 'show', 'id' => $el['id'])
                );
                if ($owner) {
                    $el['owner'] = true;
                    $el['link_shared'] = $this->context->link->getModuleLink(
                        $this->module_name,
                        'page',
                        array('action' => 'show', 'tk' => md5(_COOKIE_KEY_.$el['id']), 'id' => $el['id'])
                    );
                } else {
                    $el['owner'] = false;
                    $el['link_shared'] = $el['link'];
                }
                $el['link_search_card'] = $this->context->link->getModuleLink(
                    $this->module_name,
                    'page',
                    array('tk' => $tk, 'action' => 'searchCard', 'id_search_card' => $el['id'])
                );
                $el['link_add_cart'] = $this->context->link->getModuleLink(
                    $this->module_name,
                    'page',
                    array('tk' => $tk, 'action' => 'addCart', 'id_add_card' => $el['id'])
                );
                $id_p = explode(',', $el['id_product']);
                $el['p_list'] = array();
                $id_suscription_pack = $el['id'];
                foreach ($id_p as $id_product) {
                    $product = new Product($id_product);
                    $images = Product::getCover($id_product);
                    if (isset($el['p_list'][$id_product])) {
                        //$el['p_list'][$id_product]['cards']++;
                        continue;
                    }
                    $custom_plan = (bool)Configuration::get(
                        $this->module_name.'_custom_plan_'.$product->id,
                        null,
                        $this->id_shop_group,
                        $this->id_shop
                    );
                    if ($custom_plan) {
                        $custom_setting = (array)Tools::jsonDecode(Configuration::get(
                            $this->module_name.'_custom_setting_'.$product->id,
                            null,
                            $this->id_shop_group,
                            $this->id_shop
                        ), true);
                    } else {
                        $custom_setting = $plan_setting;
                    }
                    $valid_frequency = explode(',', $custom_setting['frequency']);
                    $valid_repetitions = explode(',', $custom_setting['repetitions']);
                    $frequency_type = $custom_setting['frequency_type'];
                    $el['p_list'][$id_product] = array(
                        'owner' => $owner,
                        'qty_first_time' => (int)Db::getInstance()->getValue('
                                SELECT sum(c.qty_first_time) as c 
                                FROM `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_sproducts` c
                                WHERE
                                    c.`id_product` = '.(int)$id_product.' AND
                                    c.`id_suscription_pack` = '.(int)$id_suscription_pack.' GROUP BY c.`id_product`'),
                        'qty_recurring_payment' => (int)Db::getInstance()->getValue('
                                SELECT sum(c.qty_recurring_payment) as c 
                                FROM `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_sproducts` c
                                WHERE
                                    c.`id_product` = '.(int)$id_product.' AND
                                    c.`id_suscription_pack` = '.(int)$id_suscription_pack.' GROUP BY c.`id_product`'),
                        'image' => $this->context->link->getImageLink(
                            $product->link_rewrite,
                            $images['id_image'],
                            ImageType::getFormatedName('small')
                        ),
                        'mini_image' => $this->context->link->getImageLink(
                            $product->link_rewrite,
                            $images['id_image'],
                            ImageType::getFormatedName('small')
                        ),
                        'name' => $product->name[$this->context->language->id],
                        'valid_frequency' => $valid_frequency,
                        'valid_repetitions' => $valid_repetitions,
                        'frequency_type' => $frequency_type,
                        'id_product' => $product->id,
                        'link' => $this->context->link->getProductLink($product),
                        'link_delete' => $this->context->link->getModuleLink(
                            $this->module_name,
                            'page',
                            array(
                                'tk' => $tk,
                                'action' => 'deleteCard',
                                'id_product' => $product->id,
                                'id_suscription_pack' => $el['id']
                            )
                        )
                    );
                }
            }
        }
    }
    private function createCart()
    {
        if (is_null($this->context->cart)) {
            $this->context->cart = new Cart($this->context->cookie->id_cart);
        }

        if (is_null($this->context->cart->id_lang)) {
             $this->context->cart->id_lang = $this->context->cookie->id_lang;
        }

        if (is_null($this->context->cart->id_currency)) {
             $this->context->cart->id_currency = $this->context->cookie->id_currency;
        }

        if (is_null($this->context->cart->id_customer)) {
             $this->context->cart->id_customer = $this->context->cookie->id_customer;
        }

        if (is_null($this->context->cart->id_guest)) {
            if (empty($this->context->cookie->id_guest)) {
                $this->context->cookie->__set(
                    'id_guest',
                    Guest::getFromCustomer($this->context->cookie->id_customer)
                );
            }
            $this->context->cart->id_guest = $this->context->cookie->id_guest;
        }

        if (is_null($this->context->cart->id)) {
             $this->context->cart->add();
             $this->context->cookie->__set('id_cart', $this->context->cart->id);
        }
        $this->context->cart->save();
    }
}
