<?php
/**
* Modulo MercadoPago Tools Pro
*
* @author    Kijam
* @copyright 2020 Kijam
* @license   Commercial use allowed (Non-assignable & non-transferable),
*            can modify source-code but cannot distribute modifications
*            (derivative works).
*/

/**
 * the name of the class should be [ModuleName][ControllerName]ModuleFrontController
 */
class MPToolsProPlanModuleFrontController extends ModuleFrontController
{
    private $config;
    private $gateway;
    private $settings;
    private $module_name;
    private $id_shop;
    private $id_shop_group;
    public $is_mp_plan = true;
    public function __construct()
    {
        parent::__construct();
        $this->context = Context::getContext();
        $this->gateway = $this->module->gateway;
        $this->module_name = $this->module->name;
        $this->config = $this->module->gateway->config;
        $this->settings = $this->module->gateway->settings;
    }
    private static function getLink($url)
    {
        $link = Context::getContext()->link;
        $base_uri = __PS_BASE_URI__;
        if (strpos($url, $base_uri) === 0) {
            $url = Tools::substr($url, Tools::strlen($base_uri));
        }
        if (strpos($url, 'index.php?controller=') !== false && strpos($url, 'index.php/') == 0) {
            $url = Tools::substr($url, Tools::strlen('index.php?controller='));
            if (Configuration::get('PS_REWRITING_SETTINGS')) {
                $url = Tools::strReplaceFirst('&', '?', $url);
            }
        }
        $explode = explode('?', $url);
        // don't use ssl if url is home page
        // used when logout for example
        $use_ssl = !empty($url);
        $url = $link->getPageLink($explode[0], $use_ssl);
        if (isset($explode[1])) {
            $url .= '?'.$explode[1];
        }
        return $url;
    }
    /**
     * @see FrontController::initContent()
     */
    public function initContent()
    {
        $this->display_column_left = false;
        $this->display_column_right = false;
        parent::initContent();
        $this->id_shop = Shop::getContextShopID();
        $this->id_shop_group = Shop::getContextShopGroupID();
        $this->context->smarty->assign(array(
            'btn_url' => $this->context->link->getModuleLink(
                $this->module_name,
                'plan',
                array('show_suscriptions' => '1')
            )
        ));
        if (!isset($this->module->gateway) || !$this->module->gateway) {
            if (Tools::isSubmit('id_product')) {
                die('{"error": "mercadopago_not_installed"}');
            } else {
                Tools::redirect('index');
            }
            exit;
        }
        if (Tools::isSubmit('show_suscriptions')) {
            $is_deleted = false;
            $is_resume = false;
            $is_pause = false;
            if (Tools::isSubmit('sdelete') && (int)Tools::getValue('sdelete') > 0) {
                $is_deleted = Db::getInstance()->Execute('UPDATE 
                            `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_preapprovals` p
                        INNER JOIN `'.bqSQL(_DB_PREFIX_).'cart` c ON c.id_cart = p.id_cart_base 
                        SET
                        `status` = \'cancel\'
                        WHERE c.`id_customer` = '.(int)pSQL($this->context->cookie->id_customer).' AND
                              p.`id` = '.(int)Tools::getValue('sdelete'));
            }
            if (Tools::isSubmit('spause') && (int)Tools::getValue('spause') > 0) {
                $is_pause = Db::getInstance()->Execute('UPDATE `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_preapprovals` p
                        INNER JOIN `'.bqSQL(_DB_PREFIX_).'cart` c ON c.id_cart = p.id_cart_base 
                        SET
                        `status` = \'pause\', last_check = '.(int)time().'
                        WHERE `status` <> \'cancel\' AND 
                               c.`id_customer` = '.(int)pSQL($this->context->cookie->id_customer).' AND
                               p.`id` = '.(int)Tools::getValue('spause'));
            }
            if (Tools::isSubmit('sresume') && (int)Tools::getValue('sresume') > 0) {
                $diff_time = time() - (int)Db::getInstance()->getValue('SELECT `last_check` FROM
                    `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_preapprovals`
                    WHERE `id` = '.(int)Tools::getValue('sresume'));
                $is_resume = Db::getInstance()->Execute('UPDATE 
                            `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_preapprovals` p
                        INNER JOIN `'.bqSQL(_DB_PREFIX_).'cart` c ON c.id_cart = p.id_cart_base 
                        SET
                            `status` = \'active\'
                        WHERE `status` <> \'cancel\' AND
                               c.`id_customer` = '.(int)pSQL($this->context->cookie->id_customer).' AND
                               p.`id` = '.(int)Tools::getValue('sresume'));
                if ($diff_time > 0 && $is_resume) {
                    $sql = 'SELECT p.* FROM `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_preapprovals` p
                                    INNER JOIN `'.bqSQL(_DB_PREFIX_).'cart` c ON c.id_cart = p.id_cart_base 
                                    WHERE c.`id_customer` = '.(int)pSQL($this->context->cookie->id_customer).' AND
                                          p.`id` = '.(int)Tools::getValue('sresume');
                    $preapprovals = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS($sql);
                    foreach ($preapprovals as &$rp) {
                        $rp['products'] = Tools::jsonDecode($rp['products'], true);
                        $rp['next_payment'] = strtotime($rp['next_payment']);
                        $rp['end_payment'] = strtotime($rp['end_payment']);
                        foreach ($rp['products']['orders'] as &$ro) {
                            $ro['next_payment'] += $diff_time;
                            $ro['end_date'] += $diff_time;
                            $ro['next_payment_txt'] = date('Y-m-d H:i:s', $ro['next_payment']);
                            $ro['end_date_txt'] = date('Y-m-d', $ro['end_date']);
                        }
                        $rp['next_payment'] += $diff_time;
                        $rp['end_payment'] += $diff_time;
                        Db::getInstance()->Execute('UPDATE `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_preapprovals` p
                            INNER JOIN `'.bqSQL(_DB_PREFIX_).'cart` c ON c.id_cart = p.id_cart_base 
                            SET
                                `products` = \''.pSQL(Tools::jsonEncode($rp['products'])).'\',
                                `next_payment` = \''.pSQL(date('Y-m-d H:i:s', $rp['next_payment'])).'\',
                                `end_payment` = \''.pSQL(date('Y-m-d H:i:s', $rp['end_payment'])).'\'
                            WHERE c.`id_customer` = '.(int)pSQL($this->context->cookie->id_customer).' AND
                                  p.`id` = '.(int)Tools::getValue('sresume'));
                    }
                }
            }
            $this->display_column_left = false;
            $this->display_column_right = false;
            $sql = 'SELECT p.* FROM `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_preapprovals` p
                            INNER JOIN `'.bqSQL(_DB_PREFIX_).'cart` c ON c.id_cart = p.id_cart_base 
                            WHERE c.`id_customer` = '.(int)pSQL($this->context->cookie->id_customer).'';
            $preapprovals = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS($sql);
            if (is_array($preapprovals) && count($preapprovals)) {
                foreach ($preapprovals as &$p) {
                    $next_send = 0;
                    $p['products'] = Tools::jsonDecode($p['products'], true);
                    if ($p['status'] == 'cancel') {
                        $p['status_txt'] = 'Cancelado';
                    } elseif ($p['status'] == 'pause') {
                        $p['status_txt'] = 'Pausado';
                    } elseif ($p['status'] == 'end') {
                        $p['status_txt'] = 'Finalizado';
                    } else {
                        $p['status_txt'] = 'Activo';
                    }
                    foreach ($p['products']['orders'] as $o) {
                        foreach ($o['products'] as $op) {
                            $oproduct = new Product($op['id_product']);
                            if (!$oproduct->is_virtual && $op['qty'] > 0) {
                                if ($next_send == 0 || $next_send > $o['next_payment']) {
                                    $next_send = $o['next_payment'];
                                }
                            }
                        }
                    }
                    $p['next_send'] = $next_send;
                    $p['next_send_txt'] = date('Y-m-d', $next_send);
                }
            } else {
                $preapprovals = false;
            }
            $this->context->smarty->assign(array(
                'preapprovals' => $preapprovals,
                'is_deleted' => $is_deleted,
                'is_pause' => $is_pause,
                'is_resume' => $is_resume,
                'base_url' => Context::getContext()->shop->getBaseURL(true)
            ));
           // UKijam::pL($preapprovals);
            $this->setTemplate('module:'.$this->module_name.'/views/templates/front/show_suscriptions.tpl');
            return;
        }
        if (!isset($this->config['plan_enable']) || !$this->config['plan_enable']) {
            if (Tools::isSubmit('id_product')) {
                die('{"error": "mercadopago_disabled_plan"}');
            } else {
                Tools::redirect('index');
            }
            exit;
        }
        $plan_setting = $this->config['plan_setting'];
        if (Tools::isSubmit('id_suscription_pack')) {
            $id_suscription_pack = (int)Tools::getValue('id_suscription_pack');
            $list = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('
                SELECT c.* FROM `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_suscription_packs` m
                LEFT JOIN `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'_sproducts` c ON m.id = c.id_suscription_pack
                WHERE
                    m.`id_shop` = '.(int)$this->id_shop.' AND
                    m.`is_public` = 1 AND
                    m.`id` = '.(int)$id_suscription_pack);
            $id_address_delivery = (int)$this->context->cart->id_address_delivery;
            if ($id_address_delivery == 0 && $this->context->customer && (int)$this->context->customer->id > 0) {
                $id_address_delivery = (int)Address::getFirstCustomerAddressId($this->context->customer->id);
            }
            $id_address_invoice = (int)$this->context->cart->id_address_invoice;
            if ($id_address_delivery == 0) {
                $id_address_delivery = (int)$id_address_delivery;
            }
            $cart = $this->context->cart = new Cart();
            $currency = Context::getContext()->currency;
            if ($id_address_delivery > 0) {
                $cart->id_address_invoice = $id_address_invoice;
                $cart->id_address_delivery = $id_address_delivery;
            }
            $cart->id_currency = $currency->id;
            if ($this->context->customer) {
                $cart->id_customer = $this->context->customer->id;
            }
            $cart->add();
            $debug = array();
            $redirect_url = self::getLink('index.php?controller=order&step=1');
            $session = array(
                'error'                => false,
                'checkout_completed'   => false,
                'plan_id'              => false,
                'id_suscription_pack'  => $id_suscription_pack,
                'orders'               => array(),
                'redirect_url'         => $redirect_url,
                'cart_id'              => $cart->id,
            );
            foreach ($list as &$el) {
                $product = new Product($el['id_product']);
                if ($product->id && $product->active) {
                    $id_product = $product->id;
                    $qty = (int)$el['qty_first_time'];
                    $qtyr = (int)$el['qty_recurring_payment'];
                    $disabled_plan = true;
                    $active_by_default = (bool)$this->config['plan_setting']['by_default'];
                    $checked = (bool)Configuration::get(
                        $this->module_name.'_disabled_plan_'.$id_product,
                        null,
                        $this->id_shop_group,
                        $this->id_shop
                    );
                    if ($active_by_default) {
                        $disabled_plan = false;
                        if ($checked) {
                            $disabled_plan = true;
                        }
                    } else {
                        $disabled_plan = true;
                        if ($checked) {
                            $disabled_plan = false;
                        }
                    }
                    if ($disabled_plan) {
                        die('{"error": "mercadopago_disabled_plan_product"}');
                    }
                    $custom_plan = (bool)Configuration::get(
                        $this->gateway->module_name.'_custom_plan_'.$id_product,
                        null,
                        $this->id_shop_group,
                        $this->id_shop
                    );
                    if ($custom_plan) {
                        $custom_setting = (array)Tools::jsonDecode(Configuration::get(
                            $this->gateway->module_name.'_custom_setting_'.$id_product,
                            null,
                            $this->id_shop_group,
                            $this->id_shop
                        ), true);
                    } else {
                        $custom_setting = $plan_setting;
                    }
                    $frequency_type = $custom_setting['frequency_type'];
                    $valid_frequency = explode(',', $custom_setting['frequency']);
                    if (count($valid_frequency) == 0) {
                        die('{"error": "mercadopago_invalid_frequency"}');
                    }
                    $frequency = $valid_frequency[0];
                    $valid_repetitions = explode(',', $custom_setting['repetitions']);
                    if (count($valid_repetitions) == 0) {
                        die('{"error": "mercadopago_invalid_repetitions"}');
                    }
                    $repetitions = $valid_repetitions[0];
                    $sproduct = array(
                        'frequency'            => $frequency,
                        'frequency_type'       => $frequency_type,
                        'repetitions'          => $repetitions,
                        'id_suscription_pack'  => $id_suscription_pack,
                        'repetitions_payed'    => 1,
                        'next_payment'         => false,
                        'last_check'           => false
                    );
                    $ohash = md5(Tools::jsonEncode($sproduct));
                    $sproduct['products'] = array();
                    if (!isset($session['orders'][$ohash])) {
                        $session['orders'][$ohash] = $sproduct;
                    }
                    $session['orders'][$ohash]['setting'] = $this->gateway->getPlanSetting($id_product);
                    $comb = array(
                        'id_product'           => $product->id,
                        'id_product_attribute' => 0,
                        'id_customization'     => 0
                    );
                    $phash = md5(Tools::jsonEncode($comb));
                    if (!isset($session['orders'][$ohash]['products'][$phash])) {
                        $comb['qty'] = (int)$qtyr;
                        $comb['name'] = $product->name[$cart->id_lang];
                        $session['orders'][$ohash]['products'][$phash] = $comb;
                    } else {
                        $session['orders'][$ohash]['products'][$phash]['qty'] += (int)$qtyr;
                    }
                    if ($qty > 0 && !$product->checkQty($qty)) {
                        die('{"error": "mercadopago_out_of_stock", "error_debug": 2}');
                    }
                }
                if ($qty > 0) {
                    $debug[] = $cart->getProducts();
                    $debug[] = $cart->id;
                    $update_quantity = $cart->updateQty($qty, $product->id);
                    $debug[] = $cart->getProducts();
                    $debug[] = $cart->id;
                    
                    if ($update_quantity < 0) {
                        // If product has attribute, minimal quantity is set with minimal quantity of attribute
                        $minimal_quantity = $product->minimal_quantity;
                        //$cart->delete();
                        die('{"error": "mercadopago_minimal_quantity", "error_debug": 3, "minimal_quantity": '.
                            (int)$minimal_quantity.'}');
                    } elseif (!$update_quantity) {
                        //$cart->delete();
                        die('{"error": "mercadopago_out_of_stock", "error_debug": 4}');
                    }
                    $cart->save();
                }
            }
            $debug[] = $cart->getProducts();
            UKijam::log('set0 plan_cart_'.$cart->id.': '.
                        UKijam::pL($session, true));
            UKijam::setCache('plan_cart_'.$cart->id, $session, 15 * 24 * 60 * 60);
            $this->context->cart = $cart;
            CartRule::autoRemoveFromCart();
            CartRule::autoAddToCart();
            $this->context->cookie->id_customer = $cart->id_customer;
            $this->context->cookie->id_cart = $cart->id;
            $this->context->cookie->id_currency = $cart->id_currency;
            $this->context->cookie->id_lang = $cart->id_lang;
            $this->context->cookie->id_guest = $cart->id_guest;
            if ($this->context->customer && $this->context->customer->id > 0) {
                $this->context->cookie->is_guest = $this->context->customer->isGuest();
            }
            $this->context->cookie->write();
            
            $debug[] = $cart->getProducts();
            $cart->save();
            $debug[] = $cart->getProducts();
            $session['cart'] = $debug;
            echo Tools::jsonEncode($session);
            exit;
        } elseif (Tools::isSubmit('cancel_item')) {
            $phash = Tools::getValue('cancel_item');
            $cart = $this->context->cart;
            $session = UKijam::getCache('plan_cart_'.$cart->id);
            foreach($session['orders'] as $ohash => $orders) {
                if (isset($session['orders'][$ohash]['products'][$phash])) {
                    $p = $session['orders'][$ohash]['products'][$phash];
                    $cart->updateQty(
                        $p['qty'],
                        $p['id_product'],
                        $p['id_product_attribute'],
                        $p['id_customization'],
                        'down',
                        (int)$cart->id_address_delivery
                    );
                    unset($session['orders'][$ohash]['products'][$phash]);
                }
                if (count($session['orders'][$ohash]['products']) == 0) {
                    unset($session['orders'][$ohash]);
                }
            }
            UKijam::setCache('plan_cart_'.$cart->id, $session, 15 * 24 * 60 * 60);
            echo Tools::jsonEncode($session);
            exit;
        } elseif (Tools::isSubmit('id_product') && Tools::isSubmit('frequency')) {
            $repetitions = Tools::isSubmit('repetitions')?Tools::getValue('repetitions'):null;
            $frequency = Tools::isSubmit('frequency')?Tools::getValue('frequency'):null;
            $qty = abs(Tools::getValue('qty', 1));
            $product = new Product(Tools::getValue('id_product'), true, $this->context->language->id);
            if (!$product->id || !$product->active) {
                die('{"error": "mercadopago_invalid_product"}');
            }
            if (!$product->id || !$product->active) {
                die('{"error": "mercadopago_invalid_product"}');
            }
            if (Tools::getIsset('group')) {
                $id_product_attribute = (int)Product::getIdProductAttributesByIdAttributes(
                    $product->id,
                    Tools::getValue('group')
                );
            } elseif (Tools::isSubmit('id_product_attribute')) {
                $id_product_attribute = (int)Tools::getValue('id_product_attribute', Tools::getValue('ipa'));
            }
            $id_product = $product->id;
            $disabled_plan = true;
            $active_by_default = (bool)$this->config['plan_setting']['by_default'];
            $checked = (bool)Configuration::get(
                $this->module_name.'_disabled_plan_'.$id_product,
                null,
                $this->id_shop_group,
                $this->id_shop
            );
            if ($active_by_default) {
                $disabled_plan = false;
                if ($checked) {
                    $disabled_plan = true;
                }
            } else {
                $disabled_plan = true;
                if ($checked) {
                    $disabled_plan = false;
                }
            }
            if ($disabled_plan) {
                die('{"error": "mercadopago_disabled_plan_product"}');
            }
            $custom_plan = (bool)Configuration::get(
                $this->gateway->module_name.'_custom_plan_'.$id_product,
                null,
                $this->id_shop_group,
                $this->id_shop
            );
            if ($custom_plan) {
                $custom_setting = (array)Tools::jsonDecode(Configuration::get(
                    $this->gateway->module_name.'(_custom_setting_)'.$id_product,
                    null,
                    $this->id_shop_group,
                    $this->id_shop
                ), true);
            } else {
                $custom_setting = $plan_setting;
            }
            $valid_frequency = explode(',', $custom_setting['frequency']);
            if (count($valid_frequency) == 0 || !in_array($frequency, $valid_frequency)) {
                die('{"error": "mercadopago_invalid_frequency"}');
            }
            $valid_repetitions = explode(',', $custom_setting['repetitions']);
            if (count($valid_repetitions) == 0 || !in_array($repetitions, $valid_repetitions)) {
                die('{"error": "mercadopago_invalid_repetitions"}');
            }
            $frequency_type = $custom_setting['frequency_type'];
            // Check product quantity availability
            if ($id_product_attribute) {
                if (!Product::isAvailableWhenOutOfStock($product->out_of_stock) &&
                    !Attribute::checkAttributeQty($id_product_attribute, $qty)) {
                    die('{"error": "mercadopago_out_of_stock", "error_debug": 0}');
                }
            } elseif ($product->hasAttributes()) {
                $minimumQuantity = ($product->out_of_stock == 2) ? !Configuration::get(
                    'PS_ORDER_OUT_OF_STOCK'
                ) : !$product->out_of_stock;
                $id_product_attribute = Product::getDefaultAttribute($product->id, $minimumQuantity);
                if (!$id_product_attribute) {
                    die('{"error": "mercadopago_invalid_product"}');
                } elseif (!Product::isAvailableWhenOutOfStock($product->out_of_stock) &&
                    !Attribute::checkAttributeQty($id_product_attribute, $qty)) {
                    die('{"error": "mercadopago_out_of_stock", "error_debug": 1}');
                }
            } elseif (!$product->checkQty($qty)) {
                die('{"error": "mercadopago_out_of_stock", "error_debug": 2}');
            }
            // Check customizable fields
            $id_customization = (int)Tools::getValue('id_customization', 0);
            if (!$product->hasAllRequiredCustomizableFields() && !$id_customization) {
                die('{"error": "mercadopago_customization_required"}');
            }
            $id_address_delivery = (int)Tools::getValue('id_address_delivery');
            if ($id_address_delivery == 0) {
                $id_address_delivery = (int)$this->context->cart->id_address_delivery;
            }
            if ($id_address_delivery == 0 && $this->context->customer && (int)$this->context->customer->id > 0) {
                $id_address_delivery = (int)Address::getFirstCustomerAddressId($this->context->customer->id);
            }
            $is_new = false;
            $cart = $this->context->cart;
            $session = UKijam::getCache('plan_cart_'.$cart->id);
            UKijam::log('get0 plan_cart_'.$cart->id.': '.
                        UKijam::pL($session, true));
            if (!$cart || $cart->id < 1 ||
                isset($session['id_suscription_pack']) && (int)$session['id_suscription_pack'] > 0) {
                $cart = $this->context->cart = new Cart();
                $is_new = true;
            }
            $currency = Context::getContext()->currency;
            if ($id_address_delivery > 0) {
                $cart->id_address_invoice = $id_address_delivery;
                $cart->id_address_delivery = $id_address_delivery;
            }
            $cart->id_currency = $currency->id;
            if ($this->context->customer) {
                $cart->id_customer = $this->context->customer->id;
            }
            if ($is_new) {
                $cart->add();
                $session = false;
            } else {
                $cart->save();
            }
            
            $sproduct = array(
                'frequency'            => $frequency,
                'frequency_type'       => $frequency_type,
                'repetitions'          => $repetitions,
                'id_suscription_pack'  => false,
                'repetitions_payed'    => 1,
                'next_payment'         => false,
                'last_check'           => false
            );
            $ohash = md5(Tools::jsonEncode($sproduct));
                    
            $sproduct['products'] = array();
            if (!$session) {
                $session = array(
                    'error'                => false,
                    'checkout_completed'   => false,
                    'plan_id'              => false,
                    'id_suscription_pack'  => false,
                    'orders'               => array($ohash => $sproduct),
                    'redirect_url'         => $redirect_url,
                    'cart_id'              => $cart->id,
                );
            } else {
                if (!isset($session['orders'][$ohash])) {
                    $session['orders'][$ohash] = $sproduct;
                }
            }
            $session['orders'][$ohash]['setting'] = $this->gateway->getPlanSetting($product->id);
            $comb = array(
                'id_product'           => (int)$product->id,
                'id_product_attribute' => (int)$id_product_attribute,
                'id_customization'     => (int)$id_customization
            );
            $cqty = $cart->getProductQuantity(
                (int)$product->id,
                (int)$id_product_attribute,
                (int)$id_customization,
                (int)$cart->id_address_delivery
            );
            $phash = md5(Tools::jsonEncode($comb));
            $qty_ant = 0;
            foreach($session['orders'] as $kos => &$os) {
                if (isset($os['products'][$phash])) {
                    $qty_ant = $os['products'][$phash]['qty'];
                    unset($os['products'][$phash]);
                    if (count($os['products']) == 0 && $kos != $ohash) {
                        unset($session['orders'][$kos]);
                    }
                }
            }
            if (empty($cqty['quantity']) || !$cqty['quantity'] || !isset($session['orders'][$ohash]['products'][$phash])) {
                $comb['qty'] = (int)$qty;
                $session['orders'][$ohash]['products'][$phash] = $comb;
                //$cart_rules = $cart->getCartRules();
                //$available_cart_rules = CartRule::getCustomerCartRules
                //($this->context->language->id, (isset($this->context->customer->id) ?
                // $this->context->customer->id : 0), true, true, true, $cart, false, true);
                $diff = $qty - $qty_ant;
                if ($diff != 0) {
                    $update_quantity = $cart->updateQty(
                        $diff > 0?$diff:-$diff,
                        $product->id,
                        $id_product_attribute,
                        $id_customization,
                        $diff > 0?'up':'down',
                        $id_address_delivery
                    );
                    if ($update_quantity < 0) {
                        // If product has attribute, minimal quantity is set with minimal quantity of attribute
                        $minimal_quantity = ($id_product_attribute) ? Attribute::getAttributeMinimalQty(
                            $id_product_attribute
                        ) : $product->minimal_quantity;
                        $cart->delete();
                        die('{"error": "mercadopago_minimal_quantity", "error_debug": 3, "minimal_quantity": '.
                                (int)$minimal_quantity.'}');
                    } elseif (!$update_quantity) {
                        $cart->delete();
                        die('{"error": "mercadopago_out_of_stock", "error_debug": 4}');
                    }
                }
            }
            // else {
            //    $session['orders'][$ohash]['products'][$phash]['qty'] += (int)$qty;
            //}
            //$old_cart = $this->context->cart->id;
            if ($is_new) {
                $this->context->cart = $cart;
                CartRule::autoRemoveFromCart();
                CartRule::autoAddToCart();
                $this->context->cookie->id_customer = $cart->id_customer;
                $this->context->cookie->id_cart = $cart->id;
                $this->context->cookie->id_currency = $cart->id_currency;
                $this->context->cookie->id_lang = $cart->id_lang;
                $this->context->cookie->id_guest = $cart->id_guest;
                if ($this->context->customer && $this->context->customer->id > 0) {
                    $this->context->cookie->is_guest = $this->context->customer->isGuest();
                }
                $this->context->cookie->write();
            }
            $redirect_url = self::getLink('index.php?controller=order&step=1');
            // Language id
            $id_lang = (int)Context::getContext()->language->id;
             
            UKijam::log('set1 plan_cart_'.$cart->id.': '.
                        UKijam::pL($session, true));
            UKijam::setCache('plan_cart_'.$cart->id, $session, 15 * 24 * 60 * 60);
            // Get cover image for your product
            $image = Image::getCover($id_product);
            // Initialize the link object
            $link = new Link;
            $img = $link->getImageLink($product->link_rewrite[$id_lang], $image['id_image'], 'home_default');
            $session['last_added'] = array(
                'image' => $img,
                'name' => $product->name[$id_lang],
                'qty' => $qty,
                'phash' => $phash,
                'suscription' => $session['orders'][$ohash],
                'cart_link' => $this->context->link->getPageLink('cart', null, null, ['action' => 'show'])
            );
            echo Tools::jsonEncode($session);
            exit;
        }
        if (Tools::isSubmit('id_product')) {
            die('{"error": "mercadopago_invalid_request"}');
        } else {
            Tools::redirect('index');
        }
        exit;
    }
}
