<?php
/**
* Modulo MercadoPago Tools Pro
*
* @author    Kijam
* @copyright 2020 Kijam
* @license   Commercial use allowed (Non-assignable & non-transferable),
*            can modify source-code but cannot distribute modifications
*            (derivative works).
*/

/**
 * the name of the class should be [ModuleName][ControllerName]ModuleFrontController
 */
class MPToolsProRedirectModuleFrontController extends ModuleFrontController
{
    private $gateway;
    private $config;
    private $settings;
    public function __construct()
    {
        parent::__construct();
        $this->context = Context::getContext();
        $this->gateway = $this->module->gateway;
        $this->config = $this->module->gateway->config;
        $this->settings = $this->module->gateway->settings;
    }

    /**
     * @see FrontController::initContent()
     */
    public function initContent()
    {
        parent::initContent();
        if (!isset($this->module->gateway) || !$this->module->gateway) {
            if (Tools::isSubmit('id_product')) {
                die('{"error": "mercadopago_not_installed"}');
            } else {
                Tools::redirect('index');
            }
            exit;
        }
        $this->gateway = $this->module->gateway;
        if (Tools::isSubmit('id_product')) {
            $this->module->gateway->checkPrice();
            exit;
        }
        if (Tools::isSubmit('topic')) {
            $this->module->gateway->ipn();
            exit;
        }
        if (Tools::isSubmit('mp_set_device_id')) {
            Context::getContext()->cookie->mp_device_id = Tools::getValue('mp_set_device_id');
            Context::getContext()->cookie->write();
            exit;
        }
        if (Tools::isSubmit('collection_status')
        || Tools::isSubmit('collection_id')
        || Tools::isSubmit('ps_ok')
        || Tools::isSubmit('ps_fail')
        || Tools::isSubmit('ps_pending')
            || Tools::isSubmit('payment_id') && Tools::isSubmit('payment_status')
            || Tools::isSubmit('merchant_order_id')) {
            $this->module->gateway->returnMP();
            exit;
        }

        $id_pending = $this->gateway->os_wait_payment;
        $name = trim($this->module->displayName);
        $id_cart = $this->context->cart->id;
        $cart = new Cart($id_cart);
        $customer = new Customer((int)$cart->id_customer);
        $currency = new Currency((int)$cart->id_currency);

        UKijam::log('Redirect controller is called: '.UKijam::pL($_GET, true));
        if (Tools::isSubmit('get_paymentbutton') && Tools::isSubmit('id_order')) {
            $order = new Order((int)Tools::getValue('id_order'));
            $id_order = (int)Db::getInstance()->getValue('
                SELECT `id_order`
                FROM `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'`
                WHERE `id_order` = '.(int)$order->id);
            if ($id_order != $order->id) {
                UKijam::log('Redirect controller: invalid order id '.UKijam::pL($order, true));
                Tools::redirect('index');
                exit;
            }
            $cart = new Cart($order->id_cart);
            $customer = new Customer((int)$cart->id_customer);
            Tools::redirect(
                'index.php?controller=order-confirmation&id_cart='.$cart->id
                .'&id_module='.$this->module->id.'&id_order='.$order->id
                .'&key='.$customer->secure_key.'&payment_type='.Tools::getValue('payment_type')
            );
        }
        if (Tools::isSubmit('gen_order')) {
            if (!Tools::isSubmit('token') && !Tools::isSubmit('mpqr_voucher') && !$this->config['preorder']) {
                UKijam::log('Redirect to cart by empty voucher: '.UKijam::pL($_POST, true));
                $emsg = urlencode($this->l('The voucher number is required.'));
                Tools::redirectLink(__PS_BASE_URI__ . 'order.php?step=1&mptools_error='.$emsg);
                return;
            }
            if (!Validate::isLoadedObject($cart)) {
                UKijam::log('Redirect controller: invalid cart: '.UKijam::pL($cart, true));
                Tools::redirect('index');
                exit;
            }
            $all_products = $cart->getProducts(true);
            if (!(bool)Configuration::get('PS_ORDER_OUT_OF_STOCK')) {
                foreach ($all_products as &$product) {
                    if (!$cart->allow_seperated_package
                        && StockAvailable::dependsOnStock($product['id_product'])
                        && $product['advanced_stock_management']
                        && (bool)Context::getContext()->customer->isLogged()
                        && ($delivery = $cart->getDeliveryOption())
                        && !empty($delivery)
                    ) {
                        $idp = (int)$product['id_product'];
                        $idpa = (int)$product['id_product_attribute'];
                        $product['stock_quantity'] = StockManager::getStockByCarrier($idp, $idpa, $delivery);
                    }
                    if (!$product['active']
                        || !$product['available_for_order']
                        || $product['stock_quantity'] < $product['cart_quantity']) {
                        UKijam::log('Redirect to cart by out of stock in cart:
                            '.UKijam::pL($product, true));
                        Tools::redirect('index.php?controller=cart&action=show');
                        exit;
                    }
                }
            }
            $customer = new Customer((int)$cart->id_customer);
            $is_ok = false;
            if (Tools::isSubmit('token')) {
                $is_plan = true;
                //$plan_custom_setting = false;
                //$plan_session = false;
                if (isset($this->config['plan_enable']) && $this->config['plan_enable']) {
                    $session = UKijam::getCache('plan_cart_'.$cart->id);
                    if ($session) {
                        UKijam::log('get3 plan_cart_'.$cart->id.': '.
                                    UKijam::pL($session, true));
                        $is_plan = false;
                        foreach ($all_products as &$p) {
                            foreach ($session['orders'] as $ohash => &$orders) {
                                foreach ($orders['products'] as &$sproducts) {
                                    if ((int)$p['id_product'] == (int)$sproducts['id_product'] &&
                                        (int)$p['id_product_attribute'] == (int)$sproducts['id_product_attribute'] &&
                                        (int)$p['id_customization'] == (int)$sproducts['id_customization']) {
                                        if (!isset($orders['setting'])) {
                                            $orders['setting'] = $this->gateway->getPlanSetting($p['id_product']);
                                        }
                                        $sproducts['found'] = true;
                                        $is_plan = $ohash;
                                        if ($sproducts['qty'] > $p['cart_quantity']) {
                                            $sproducts['qty'] = $p['cart_quantity'];
                                        }
                                    }
                                }
                            }
                        }
                        /* foreach ($session['orders'] as $ohash => &$orders) {
                            foreach ($orders['products'] as $phash => &$sproducts) {
                                if (!isset($sproducts['found'])) {
                                    unset($orders['products'][$phash]);
                                }
                            }
                            if (count($orders['products']) == 0) {
                                unset($orders['orders'][$ohash]);
                            }
                        } */
                        UKijam::log('set2 plan_cart_'.$cart->id.': '.
                                    UKijam::pL($session, true));
                        UKijam::setCache('plan_cart_'.$cart->id, $session, 15 * 24 * 60 * 60);
                    } else {
                        $is_plan = false;
                    }
                    //if ($is_plan) {
                    //    $plan_session = $session;
                    //}
                } else {
                    $is_plan = false;
                }
                $decimals = $this->settings['UNIT_PRICE_TYPE'] == 'INTEGER'?0:2;
                $rate_dst = UKijam::getRate(
                    Tools::strtoupper($currency->iso_code),
                    Tools::strtoupper($this->settings['CURRENCY'])
                );
                $cart_prices = UKijam::getCartOrderTotal($cart);
                $total_price = $cart_prices['both'] * $rate_dst;
                $shipping_price = $cart_prices['shipping'] * $rate_dst;
                $fee = 100.0 / (100.0 - (float)$this->config['fee_custom']);
                $famount = $this->config['fee_amount_custom'];
                $price = Tools::ps_round($fee * $total_price + $famount - $shipping_price, $decimals);
                $additional_info = "Carrito No: {$cart->id} - ";
                $is_first_item = true;
                foreach ($all_products as &$p) {
                    if ($is_first_item) {
                        $is_first_item = false;
                        $additional_info .= $p['name'].'('.$p['quantity'].' U.)';
                    } else {
                        $additional_info .= ' - '.$p['name'].'('.$p['quantity'].' U.)';
                    }
                    if (isset($p['attributes']) && !empty($p['attributes'])) {
                        $additional_info .= ', '.str_replace('-', ',', $p['attributes']);
                    }
                }
                $description = Tools::substr($additional_info, 0, 115);
                if (Tools::strlen($description) < Tools::strlen($additional_info)) {
                    $description .= ' |HAY MAS|';
                }
                $ipn_url = Context::getContext()->link->getModuleLink('mptoolspro', 'redirect', array('RgExcludeLocationDetection' => 1));
                $token = Tools::getValue("token");
                $payment_method_id = Tools::getValue("payment_method_id");
                $installments = Tools::getValue("installments");
                $issuer_id = Tools::getValue("issuer_id");
                try {
                    $c = false;
                    MercadoPago\SDK::cleanCredentials();
                    MercadoPago\SDK::setAccessToken($this->config['secretkey']);
                    MercadoPago\SDK::addCustomTrackingParam('x-integrator-id', 'dev_ea5f644448e411ec8c840242ac130004');
                    if (isset(Context::getContext()->cookie->mp_device_id) && !empty(Context::getContext()->cookie->mp_device_id)) {
                        MercadoPago\SDK::addCustomTrackingParam('X-meli-session-id', Context::getContext()->cookie->mp_device_id);
                    }
                    $payment = new MercadoPago\Payment();
                    $payment->transaction_amount = $decimals?(float)Tools::ps_round($price, $decimals):(int)$price;
                    $payment->shipping_amount = $decimals?(float)Tools::ps_round($shipping_price, $decimals):(int)$shipping_price;
                    if ($is_plan) {
                        $filters = array ("email" => $customer->email);
                        $s = MercadoPago\Customer::search($filters);
                        $iterator = $s->getIterator();
                        for ($iterator->rewind(); $iterator->valid(); $iterator->next()) {
                            $c = $iterator->current();
                            UKijam::log('Search result:
                                '.UKijam::pL($c, true));
                            break;
                        }
                        if (!$c) {
                            $c = new MercadoPago\Customer();
                            $c->email = $customer->email;
                            $address = new Address((int)$cart->id_address_invoice);
                            $c->first_name = !empty($address->firstname)?$address->firstname:$customer->firstname;
                            $c->last_name = !empty($address->lastname)?$address->lastname:$customer->lastname;
                            $phone = !empty($address->phone)?$address->phone:$address->phone_mobile;
                            $c->phone = array(
                                "area_code" => "",
                                "number" => preg_replace('/[^0-9]/', '', $phone)
                            );
                            $c->identification = array(
                                'type' => !empty($address->vat_number)?'VAT':$this->settings['DNI_NAME'],
                                "number" => !empty($address->vat_number)?$address->vat_number:$address->dni,
                            );
                            $c->address = array(
                                //No descomentar, da problemas
                                //'zip_code' => preg_replace('/[^0-9]/', '', $address->postcode),
                                'street_name' => preg_replace(
                                    '/[^0-9a-zA-Z .,-]/',
                                    '',
                                    str_replace(
                                        array('ñ', 'Ñ', 'á', 'é', 'í', 'ó', 'ú', 'Á', 'É', 'Í', 'Ó', 'Ú'),
                                        array('n', 'N', 'a', 'e', 'i', 'o', 'u', 'A', 'E', 'I', 'O', 'U'), 
                                        $address->address1
                                    )
                                ),
                                'street_number' => preg_replace('/[^0-9]/', '', $address->address2),
                            );
                            $c->save();
                            UKijam::log('New Customer:
                                '.UKijam::pL($c, true));
                        }
                        $payment->token = $token;
                    } else {
                        $payment->token = $token;
                    }
                    $payment->description = $description;
                    $payment->installments = $installments;
                    $payment->payment_method_id = $payment_method_id;
                    $payment->issuer_id = $issuer_id;
                    if (isset($this->config['mp_merchant_gateway']) && $this->config['mp_merchant_gateway']) {
                        $payment->processing_mode = 'gateway';
                        $payment->binary_mode = true;
                    } else {
                        if (isset($this->config['mp_binary_mode']) && $this->config['mp_binary_mode']) {
                            $payment->binary_mode = true;
                        } else {
                            $payment->binary_mode = false;
                        }
                    }
                    $payment->external_reference = 'C-'.$cart->id.'-cu';
                    $payment->notification_url = $ipn_url;
                    $payer = new MercadoPago\Payer();
                    if ($is_plan) {
                        $payer->id = $c->id;
                    } else {
                        $address = new Address((int)$cart->id_address_invoice);
                        $payer->first_name = !empty($address->firstname)?$address->firstname:$customer->firstname;
                        $payer->last_name = !empty($address->lastname)?$address->lastname:$customer->lastname;
                        $payer->email = $customer->email;
                        $payer->identification = array(
                            'type' => !empty($address->vat_number)?'VAT':$this->settings['DNI_NAME'],
                            "number" => !empty($address->vat_number)?$address->vat_number:$address->dni,
                        );
                        $payer->address = array(
                            //No descomentar, da problemas
                            //'zip_code' => preg_replace('/[^0-9]/', '', $address->postcode),
                            'street_name' => $address->address1,
                            'street_number' => $address->address2,
                        );
                    }
                    $payment->payer = $payer;
                    UKijam::log('Payment(Tokenizer): '.
                        UKijam::pL($payment, true));
                    // Guarda y postea el pago
                    $payment->save();
                    UKijam::log('Payment result: '.
                        UKijam::pL($payment, true));
                    if (isset($payment->error) &&
                        isset($payment->error->message) &&
                        !empty($payment->error->message)) {
                        UKijam::log('Payment error: '.
                            UKijam::pL($payment->error, true));
                        Tools::redirectLink(__PS_BASE_URI__.
                            'order.php?step=3&mptools_error='.urlencode('Ocurrio un problema con su tarjeta, '.
                                'Detalles tecnicos: '.$payment->error->message));
                        return;
                    }
                    if (in_array($payment->status, array('approved', 'authorized', 'pending', 'in_process'))) {
                        $payment_id = $payment->id;
                        $is_ok = $this->gateway->checkResponseMP(
                            $id_cart,
                            false,
                            $payment_id,
                            Tools::jsonEncode($payment),
                            '_custom'
                        );
                        if (!$is_ok || $is_ok['error']) {
                            Tools::redirectLink(
                                __PS_BASE_URI__.'order.php?step=3&mptools_error='.urlencode($is_ok['error_str'])
                            );
                            return;
                        }
                        if ($is_plan) {
                            $card = new MercadoPago\Card();
                            $card->token = $token;
                            $card->customer_id = $c->id;
                            $card->save();
                            UKijam::log('Card:
                                '.UKijam::pL($card, true));
                            $this->gateway->createOrderPlan(
                                $session,
                                $card->id.'#-#'.$card->customer_id.'#-#'.$id_cart,
                                $is_plan
                            );
                        }
                        $id_order = Order::getOrderByCartId($id_cart);
                        $order = new Order($id_order);
                    } else {
                        Tools::redirectLink(
                            __PS_BASE_URI__.'order.php?step=3&mptools_error='.urlencode('Su pago no fue aprobado')
                        );
                        return;
                    }
                } catch (\Exception $e) {
                    UKijam::log('Payment Exception: '.
                        UKijam::pL($e, true));
                    Tools::redirectLink(__PS_BASE_URI__.
                        'order.php?step=3&mptools_error='.urlencode('Su pago no fue aprobado'));
                    return;
                }
            } elseif (Tools::isSubmit('mpqr_voucher')) {
                $is_ok = $this->gateway->checkResponseMP(
                    $id_cart,
                    false,
                    Tools::getValue('mpqr_voucher'),
                    false,
                    '_qr'
                );
                if (!$is_ok || $is_ok['error']) {
                    Tools::redirectLink(
                        __PS_BASE_URI__ . 'order.php?step=3&mptools_error='.urlencode($is_ok['error_str'])
                    );
                    return;
                }
                $id_order = Order::getOrderByCartId($id_cart);
                $order = new Order($id_order);
            } else {
                UKijam::log('Redirect controller: generating order cart: '.UKijam::pL($cart, true));
                $this->module->validateOrder(
                    $id_cart,
                    $id_pending,
                    $cart->getOrderTotal(true, Cart::BOTH),
                    !empty($name)?$name:'MercadoPago',
                    $this->module->waitingPayment(),
                    array(),
                    (int)$cart->id_currency,
                    false,
                    $customer->secure_key
                );
                $id_order = Order::getOrderByCartId($id_cart);
                $order = new Order($id_order);
                //$plan_custom_setting = false;
                //$plan_session = false;
                $result = $this->module->gateway->createInitPoint($cart, $order, (int)Tools::getValue('installment'));
                $result['init_point'] = $result['preference']?$result['preference']->init_point:false;
                if (!$result['init_point']) {
                    $order->setCurrentState($this->config['os_refused']);
                }
                UKijam::log('Redirect controller: order created: '.UKijam::pL($order, true));
                Db::getInstance()->Execute('
                        INSERT INTO `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'`
                        (
                            id_order, id_cart, id_shop,
                            `topic`, mp_op_id, is_sandbox,
                            status, next_retry, first_check, is_mercadoenvios,
                            shipping_id, order_reference,
                            mp_init_point, next_retry_mercadoenvios
                        )
                            VALUES
                        ('.(int)$order->id.', '.(int)$cart->id.', '.(int)$order->id_shop.',
                         \'\',
                         \'\',
                         0,
                         '.(int)$order->getCurrentState().',
                         '.(int)(time() + (1 + $this->config['max_expiration_hours']) * 60 * 60).', '.(int)time().',
                         '.(isset($result['is_mp_envios'])?(int)$result['is_mp_envios']:0).',
                         NULL,
                         \''.pSQL($order->reference).'\',
                         \''.pSQL($result['init_point']).'\',
                         '.(int)(time() + 3 * 60 * 60).')');
            }
            $redirect_button = Context::getContext()->link->getModuleLink('mptoolspro', 'redirect', array(
                'get_paymentbutton' => 1,
                'id_order' => $id_order,
                'payment_type' => Tools::getValue('payment_type')
            ));
            Tools::redirect($redirect_button);
            exit;
        }
        Tools::redirect('index');
    }
}
