<?php

// autoload_real.php @generated by Composer

class ComposerAutoloaderInit5a9fd6a9b2e6579f902abdb78d391973
{
    private static $loader;

    public static function loadClassLoader($class)
    {
        if ('Composer\Autoload\ClassLoader' === $class) {
            require __DIR__ . '/ClassLoader.php';
        }
    }

    public static function getLoader()
    {
        if (null !== self::$loader) {
            return self::$loader;
        }

        spl_autoload_register(array('ComposerAutoloaderInit5a9fd6a9b2e6579f902abdb78d391973', 'loadClassLoader'), true, true);
        self::$loader = $loader = new \Composer\Autoload\ClassLoader();
        spl_autoload_unregister(array('ComposerAutoloaderInit5a9fd6a9b2e6579f902abdb78d391973', 'loadClassLoader'));

        $is_17 = version_compare(_PS_VERSION_, '1.7.0.0') >= 0;
        $is_171 = version_compare(_PS_VERSION_, '1.7.1.0') >= 0;
        $useStaticLoader = PHP_VERSION_ID >= 50600 && !defined('HHVM_VERSION') && (!function_exists('zend_loader_file_encoded') || !zend_loader_file_encoded());
        if ($useStaticLoader) {
            if ($is_17)
                require_once __DIR__ . '/autoload_static17.php';
            else
                require_once __DIR__ . '/autoload_static.php';
            call_user_func(\Composer\Autoload\ComposerStaticInit5a9fd6a9b2e6579f902abdb78d391973::getInitializer($loader));
        } else {
            if ($is_17)
                $map = require_once __DIR__ . '/autoload_namespaces17.php';
            else
                $map = require_once __DIR__ . '/autoload_namespaces.php';
            foreach ($map as $namespace => $path) {
                $loader->set($namespace, $path);
            }

            if ($is_17)
                $map = require_once __DIR__ . '/autoload_psr417.php';
            else
                $map = require_once __DIR__ . '/autoload_psr4.php';
            foreach ($map as $namespace => $path) {
                $loader->setPsr4($namespace, $path);
            }

            if ($is_17)
                $map = require_once __DIR__ . '/autoload_classmap17.php';
            else
                $map = require_once __DIR__ . '/autoload_classmap.php';
            if ($map) {
                $loader->addClassMap($map);
            }
        }

        $loader->register(true);

        return $loader;
    }
}
