<?php
/**
* Upgrade de MercadoPago
*
* @author    Kijam
* @copyright 2020 Kijam
* @license   Comercial
*/

if (!defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_5_2_1($mp)
{
    if (!$mp || $mp->name != 'mptoolspro') {
        $mp = Module::getInstanceByName('mptoolspro');
    }
    if (!$mp->gateway) {
        return true;
    }
    UKijam::log('upgrade_module_5_2_1 init...');
    $mp->registerHook('actionCartUpdateQuantityBefore');
    $mp->registerHook('actionDeleteProductInCartAfter');
    $mp->registerHook('actionObjectProductInCartDeleteAfter');
    $mp->registerHook('displayCartExtraProductActions');
    Db::getInstance()->Execute('
        ALTER TABLE `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'`
            ADD COLUMN `first_check` BIGINT(20) DEFAULT NULL
    ');
    $valid = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS('
        SELECT id_order, id_cart, id  FROM `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'`
        WHERE `id_order` > 0 OR `id_cart` > 0
        ORDER BY id_order');
    foreach ($valid as &$v) {
        $order = new Order($v['id_order']);
        $first_date = strtotime("-5 days");
        if (Validate::isLoadedObject($order) && $order->id) {
            $first_date = strtotime($order->date_add);
        } else {
            $cart = new Cart($v['id_cart']);
            if (Validate::isLoadedObject($cart) && $cart->id) {
                $first_date = strtotime($cart->date_add);
            }
        }
        Db::getInstance()->Execute('UPDATE `'.bqSQL(_DB_PREFIX_.UKijam::DB_PREFIX).'`
            SET
                `first_check` = '.(int)($first_date).'
            WHERE id = '.(int)$v['id']);
    }
    UKijam::log('upgrade_module_5_2_1 end!');
    return true;
}