/**
* Modulo MercadoPago Tools Pro
*
* @author    Kijam
* @copyright 2020 Kijam
* @license   Comercial
*/
jQuery(document).ready(function() {
    jQuery('.list_image_gallery').lightSlider({
        gallery: true,
        item: 1,
        loop: true,
        //thumbItem:9,
        slideMargin:0,
        enableDrag: true,
        currentPagerPosition:'left',
        onSliderLoad: function(el) {
            el.lightGallery({
                selector: '.list_image_gallery .lslide'
            });
        }
    });
});

function confirmDialogCard(modal_message, modal_content, url_callback, fn_callback, params, fn_close_callback) {
    var $ = jQuery;
    if (!params) params = {};
    $('#modal_message').html(modal_message);
    $('#modal_content').html(modal_content);
    $('#card-modal .btn-primary').attr("onclick", "").unbind("click");
    $('#card-modal .btn-primary').hide(0);
    $('#card-modal').modal('show');
    $('#card-modal').unbind('hidden.bs.modal');
    if (fn_close_callback) {
        $('#card-modal').bind('hidden.bs.modal', fn_close_callback);
    }
    $('#card-modal .autoselect').click(function() {
        $(this).select();
        document.execCommand("copy");
    });
    if (url_callback) {
        $('#card-modal .btn-primary').show(0);
        $('#card-modal .btn-primary').click(function() {
            var p = {};
            for(var i in params) {
                if (params[i].selector) {
                    p[i] = $(params[i].selector).val();
                } else {
                    p[i] = params[i].value;
                }
            }
            $.post(url_callback, p, function( data ) {
                console.log( data );
                var data = jQuery.parseJSON(data);
                if (data.error) {
                    alert(data.error);
                    if(fn_callback) {
                        if (!fn_callback(data.error, data)) {
                            return;
                        }
                    }
                } else {
                    if(fn_callback) {
                        if (!fn_callback(false, data)) {
                            return;
                        }
                    }
                    $('#card-modal').modal('hide');
                }
            });
        });
    } else if(fn_callback) {
        $('#card-modal .btn-primary').show(0);
        $('#card-modal .btn-primary').click(function() {
            if(fn_callback()) {
                $('#card-modal').modal('hide');
            }
        });
    } else {
        //$('#card-modal').modal('hide');
    }
}