{*
* Hook - Despliegue descripcion del pago
*
* @author    Kijam
* @copyright 2020 Kijam
* @license   Commercial use allowed (Non-assignable & non-transferable),
*            can modify source-code but cannot distribute modifications
*            (derivative works).
*}
<div class="row" id="mptoolspro_status">
    <div class="col-lg-12">
        <div class="panel card">
            <div class="panel-heading card-header">
                <i class="icon-credit-card"></i>
                    {l s='MercadoPago' mod='mptoolspro'}
            </div>
            <div class="well card-body">
                <b>{l s='Order ID' mod='mptoolspro'}: </b> {$order_id|escape:'htmlall':'UTF-8'}<br />
                <b>{l s='MercadoPago Payment ID' mod='mptoolspro'}: </b> {$mp_validation.mp_op_id|escape:'htmlall':'UTF-8'}<br />
                <b>{l s='Order Price: ' mod='mptoolspro'}</b> {$mp_validation.price|round:2|escape:'htmlall':'UTF-8'} {$mp_validation.currency_id|escape:'htmlall':'UTF-8'}<br />
                <b>{l s='Fee Price: ' mod='mptoolspro'}</b> {$mp_validation.fee|round:2|escape:'htmlall':'UTF-8'} {$mp_validation.currency_id|escape:'htmlall':'UTF-8'}<br />
                <b>{l s='Total Payment: ' mod='mptoolspro'}</b> {$mp_validation.total|round:2|escape:'htmlall':'UTF-8'} {$mp_validation.currency_id|escape:'htmlall':'UTF-8'}<br />
                <b>{l s='Client Name: ' mod='mptoolspro'}</b> {$mp_validation.client_name|escape:'htmlall':'UTF-8'}<br />
                <b>{l s='Client Identification: ' mod='mptoolspro'}</b> {$mp_validation.identification|escape:'htmlall':'UTF-8'}<br />
                <b>{l s='Card number: ' mod='mptoolspro'}</b> {$mp_validation.last_four_digits|escape:'htmlall':'UTF-8'}<br />
                <b>{l s='Card brand: ' mod='mptoolspro'}</b> {$mp_validation.card_brand|escape:'htmlall':'UTF-8'}<br />
                <b>{l s='Cardholder name: ' mod='mptoolspro'}</b> {$mp_validation.cardholder_name|escape:'htmlall':'UTF-8'}<br />
                <b>{l s='Last Sync' mod='mptoolspro'}: </b> {$mp_last_sync|escape:'htmlall':'UTF-8'}<br />
                <b>{l s='Last Status' mod='mptoolspro'}: </b> {$mp_status|escape:'htmlall':'UTF-8'}<br />
                <b>{l s='Status Detail' mod='mptoolspro'}: </b> {$mp_validation.status_detail|escape:'htmlall':'UTF-8'}
                {if $has_refund}
                    <br /><b>{l s='Refund Date: ' mod='mptoolspro'}</b> {$has_refund.date_create|escape:'htmlall':'UTF-8'}
                {/if}
                {if $mp_label_shipping}
                    {if isset($mp_label_shipping.ok)}
                        {foreach from=$mp_label_shipping.ok item=label}
                            <br /><b>{l s='Download Label: ' mod='mptoolspro'}</b> <a href="{$label|escape:'htmlall':'UTF-8'}" target="_blank">{l s='Download' mod='mptoolspro'}</a><br /><br />
                        {/foreach}
                    {/if}
                    {if isset($mp_label_shipping.error)}
                        {foreach from=$mp_label_shipping.error item=label}
                            <br /><b>{l s='Download Label: ' mod='mptoolspro'}</b> {$label|escape:'htmlall':'UTF-8'}<br /><br />
                        {/foreach}
                    {/if}
                    {if $manual_tracking == 'required'}
                    <br /><br /><form method="POST" action="">
                        <b>{l s='Tracking code: ' mod='mptoolspro'}</b> <input name="mp_tracking_code" type="text" /><br />
                        <b>{l s='Courier Name: ' mod='mptoolspro'}</b> <select name="mp_courier_url">
                            {if $mp_country == 'MLA'}
                                <option value="http://tracking.ocasa.com/Tracking/index?airbillnumber=@&i=18&url=ocasa">{l s='Ocasa' mod='mptoolspro'}</option>
                                <option value="https://seguimiento.andreani.com/">{l s='Andreani' mod='mptoolspro'}</option>
                                <option value="http://www.iflow21.com/index.php/es/segui-tu-envio">{l s='i-Flow' mod='mptoolspro'}</option>
                                <option value="http://tracker.motonorte.com.ar/ml/index.php?tracking=@">{l s='Moto Norte' mod='mptoolspro'}</option>
                                <option value="https://www.correoargentino.com.ar/empresas/tyt/service.php?cliente=16276000&id=@">{l s='Correos Argentinos' mod='mptoolspro'}</option>
                                <option value="http://www5.oca.com.ar/ocaepakNet/Views/ConsultaTracking/TrackingConsult.aspx?numberTracking=@">{l s='OCA' mod='mptoolspro'}</option>
                            {/if}
                            <option value="">{l s='Other (Report new courier in info@kijam.com)' mod='mptoolspro'}</option>
                        </select><br />
                        <button class="btn btn-success" type="submit">
                            {l s='Save Tracking Code' mod='mptoolspro'}
                        </button>
                    </form>
                    {/if}
                {/if}
            </div>
        </div>
    </div>
</div>
<script>
    $('#mptoolspro_status').prependTo($('#mptoolspro_status').parent());
</script>
