{*
* Template para MercadoPago
*
* @author    Kijam
* @copyright 2020 Kijam
* @license   Commercial use allowed (Non-assignable & non-transferable),
*            can modify source-code but cannot distribute modifications
*            (derivative works).
*}
<style>
    #MP-Checkout-dialog {
        z-index: 200000 !important;
    }
    #MP-Checkout-IFrame {
        padding-top: 10px;
        padding-right: 10px;
    }
    #MP-Checkout-dialog > div:nth-child(1) {
        right: 20px;
        top: 3px;
    }
    #botonMP {
        padding: 0;
        padding-left: 20px;
        padding-right: 20px;
    }
</style>

<script src="https://www.mercadopago.com/v2/security.js" view="{if isset($mp_current_page)}{$mp_current_page}{else}home{/if}"></script>

<script>
    var mp_device_id = '{if isset($mp_device_id)}{$mp_device_id}{else}{/if}';
    setInterval(function() {
        if (typeof jQuery == 'undefined' || typeof window.MP_DEVICE_SESSION_ID == 'undefined') return;
        var $ = jQuery;
        var check_device_id = window.MP_DEVICE_SESSION_ID;
        if (check_device_id && check_device_id != mp_device_id) {
            mp_device_id = check_device_id;
            $.post('{$mp_ajax_link}', {
                mp_set_device_id: mp_device_id
            });
        }
    }, 1000);
</script>

{if $publickey}
<script>
    var mp_fee_installment = {$fee_installment nofilter};
    var mp_decimals = {
        maximumFractionDigits: {$decimals}
    };
    var mp_dapply_fee_installment = {$apply_fee_installment};
    function calcInstallments(credit_card, price, result_div) {
        var $ = jQuery;
        if (!result_div) result_div = "#result_installments";
        if (credit_card.length != 6) {
            $(result_div).html("<b style=\'color:red\'>{l s='You must enter the first six digits of your card' mod='mptoolspro'}</b>");
        } else {
            $(result_div).html("{l s='Loading...' mod='mptoolspro'}");
            Mercadopago.getInstallments(
                {
                    "bin": credit_card,
                    "amount": price
                },
                function(status, data) {
                    var html = "", price_base = 0, i_price = 0;
                    if (status != 200) {
                        html = "<b style=\'color: #148008\'>{l s='Error on MercadoPago or your Credit Card is invalid. Technical details:' mod='mptoolspro'} " + data.cause[0].code + " -> " + data.cause[0].description+"</b>";
                    } else {
                        html += "<ul style=\"list-style-type: disc;list-style-position: outside;list-style-image: none;\">";
                        for (var i in data[0].payer_costs) {
                            var cost = data[0].payer_costs[i];
                            var labels = '';
                            if (mp_dapply_fee_installment) {
                                if (typeof mp_fee_installment[cost.installments] == 'undefined')
                                    continue;
                                if (i == 0) {
                                    i_price = price_base = cost.total_amount;// * mp_fee_installment[1].fee_percent + mp_fee_installment[1].fee_amount;
                                } else {
                                    i_price = price_base * mp_fee_installment[cost.installments].fee_percent;
                                }
                                var c = new Intl.NumberFormat("de-DE", mp_decimals).format(i_price / cost.installments);
                                var total = new Intl.NumberFormat("de-DE", mp_decimals).format(i_price);
                                if (i == 0) {
                                    html += "<li>"+cost.installments+" cuota de $ "+c+""+labels+"</li>";
                                } else {
                                    html += "<li>"+cost.installments+" cuotas de $ "+c+" (Total: $ "+total+")"+labels+"</li>";
                                }
                            } else {
                                if (cost.labels && cost.labels.length > 0) {
                                    for(var j in cost.labels) {
                                        if (cost.labels[j].indexOf("CFT") >= 0 || cost.labels[j].indexOf("TEA") >= 0)
                                            labels += ", "+cost.labels[j].replace(/_+/ig, " ").replace(/\|/ig, ", ");
                                    }
                                }
                                html += "<li>"+cost.recommended_message+labels+"</li>";
                            }
                        }
                        html += "</ul>";
                    }
                    $(result_div).html(html);
                    console.log(html);
                }
            );
        }
    }
    exports = undefined;
</script>
{/if}
<script>
    var mps_cart_item_suscription = '{l s='Te estas suscribiendo a {qty} unidad(es) cada {frequency} {frequency_type} por {repetitions} ocaciones.' mod='mptoolspro'}';
    setInterval(function() {
        if ("undefined" != typeof window.jQuery) {
            var $ = jQuery;
            if ($(".is_mercadopago").length > 0 && (!$(".is_mercadopago").hasClass("mp_reload_renderjs") || $("#mp_render_script").length < 1)) {
                $("#mp_render_script").remove();
                $(".is_mercadopago").addClass("mp_reload_renderjs");
                $.getScript("https://www.mercadopago.com/org-img/jsapi/mptools/buttons/render.js?s=" + Math.random(), function() {
                    $("script:last").attr("id", "mp_render_script");
                });
            }
            {if isset($publickey) && $publickey}

            if ($(".result_installment_class").length > 0 && !$(".result_installment_class").hasClass("mp_installment_script_loaded")) {
                $.getScript("https://secure.mlstatic.com/sdk/javascript/v1/mercadopago.js?s=" + Math.random(), function() {
                    $(".result_installment_class").addClass("mp_installment_script_loaded");
                    Mercadopago.setPublishableKey("{$publickey|escape:'htmlall':'UTF-8'}");
                });
            }

            {/if}
        }
    }, 1000);
</script>

<div id="blockmpsuscription-modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myMpSuscriptionLabel" style="display: none;" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close" onclick="clickOnButton('close_icon')">
          <span aria-hidden="true" onclick="clickOnButton('close_icon')">×</span>
        </button>
        <h4 class="modal-title h6 text-sm-center" id="myMpSuscriptionLabel"><i class="material-icons rtl-no-flip"></i>Suscripcion añadida con exito al carrito.</h4>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-5 divide-right">
            <div class="row">
              <div class="col-md-12">
                <img class="product-image" src="" alt="" title="" style="width: 100%;" itemprop="image">
              </div>
            </div>
          </div>
          <div class="col-md-7">
            <div class="cart-content">
                <div class="row">
                    <div class="col-md-12">{l s='Se añadio la suscripcion correctamente al carrito.' mod='mptoolspro'}</div>
                    <div class="col-md-12"><br /></div>
                    <div class="col-md-12"><br /></div>
                    <div class="cart-content-btn">
                        <div class="col-md-12">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal" onclick="clickOnButton('add_more_products:button')">{l s='+ Productos' mod='mptoolspro'}</button>
                        </div>
                        <div class="col-md-12"><br /></div>
                        <div class="col-md-12">
                            <a href="" class="mps_tocart btn btn-primary" onclick="clickOnButton('confirm_order:button')">{l s='Confirmar pedido' mod='mptoolspro'}</a>
                        </div>
                    </div>
                </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>